/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.basics;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.basics.InventoryCacheDto;
import com.dtyunxi.yundt.cube.center.inventory.share.enums.CsInventoryLocationEnum;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CsInventorySourceDto
extends CsInventoryInOutBasicsCargoDto {
    @JSONField(serialize=false)
    private List<CsInventoryLocationEnum> searchLocations;
    @ApiModelProperty(name="inOutFlag", value="\u51fa\u5165\u5e93\u6807\u8bc6  in-\u5165\u5e93  out-\u51fa\u5e93")
    @JSONField(serialize=false)
    protected String inOutFlag;
    @ApiModelProperty(name="balance_b", value="\u5f02\u52a8\u524d\u603b\u5e93\u5b58")
    protected BigDecimal balance_b;
    @ApiModelProperty(name="preempt_b", value="\u5f02\u52a8\u524d\u9884\u5360\u5e93\u5b58")
    protected BigDecimal preempt_b;
    @ApiModelProperty(name="allocate_b", value="\u5f02\u52a8\u524d\u5df2\u5206\u914d\u5e93\u5b58")
    protected BigDecimal allocate_b;
    @ApiModelProperty(name="available_b", value="\u5f02\u52a8\u524d\u53ef\u7528\u5e93\u5b58")
    protected BigDecimal available_b;
    @ApiModelProperty(name="balance_e", value="\u5f02\u52a8\u540e\u603b\u5e93\u5b58")
    protected BigDecimal balance_e;
    @ApiModelProperty(name="preempt_e", value="\u5f02\u52a8\u540e\u9884\u5360\u5e93\u5b58")
    protected BigDecimal preempt_e;
    @ApiModelProperty(name="allocate_e", value="\u5f02\u52a8\u540e\u5df2\u5206\u914d\u5e93\u5b58")
    protected BigDecimal allocate_e;
    @ApiModelProperty(name="available_e", value="\u5f02\u52a8\u540e\u53ef\u7528\u5e93\u5b58")
    protected BigDecimal available_e;
    @ApiModelProperty(name="sourceDtos", value="\u6e90\u4ed3\u5206\u7c7b\u5217\u8868")
    protected List<CsInventorySourceDto> sourceDtos = new ArrayList<CsInventorySourceDto>();

    public CsInventorySourceDto() {
    }

    public CsInventorySourceDto(String warehouseClassify, String warehouseCode) {
        this.warehouseClassify = warehouseClassify;
        this.warehouseCode = warehouseCode;
    }

    @JSONField(serialize=false)
    public InventoryCacheDto findSourceCache() {
        String key = this.getWarehouseCode();
        String group = "_inventory";
        InventoryCacheDto obj = new InventoryCacheDto(this.getWarehouseClassify());
        obj.setKey(key);
        obj.setGroup(group);
        obj.setFiled(null);
        return obj;
    }

    @JSONField(serialize=false)
    public String findSourceCacheKey() {
        return this.findSourceCache().getCacheKey();
    }

    @JSONField(serialize=false)
    public List<InventoryCacheDto> getInventoryCache() {
        return CollectionUtils.isNotEmpty(this.searchLocations) ? this.getSearchInventoryCache() : this.excuteInventoryCahce();
    }

    @JSONField(serialize=false)
    private List<InventoryCacheDto> excuteInventoryCahce() {
        ArrayList<InventoryCacheDto> objs = new ArrayList<InventoryCacheDto>();
        String key = this.getWarehouseCode() + ":" + this.getSkuCode();
        String group = "_inventory";
        Arrays.stream(this.getClass().getSuperclass().getSuperclass().getDeclaredFields()).forEach(field -> {
            if (field.getType() == BigDecimal.class && CsInventoryLocationEnum.getByCode(field.getName()) != null) {
                try {
                    BigDecimal value;
                    if (field.get(this) != null && BigDecimal.ZERO.compareTo(value = new BigDecimal(field.get(this).toString())) != 0) {
                        InventoryCacheDto eo = new InventoryCacheDto(this.getWarehouseClassify());
                        String name = field.getName();
                        eo.setGroup(group);
                        eo.setKey(key);
                        eo.setFiled(name);
                        eo.setValue(value);
                        if ("available".equals(name)) {
                            eo.setValidate(this.getNegativeValidate());
                            eo.setLowerLimit(this.getLowerLimit());
                            eo.setUpLimit(this.getUpperLimit());
                        } else {
                            eo.setValidate(0);
                        }
                        objs.add(eo);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
        BigDecimal available = this.getAvailableQuantity();
        if (BigDecimal.ZERO.compareTo(available) != 0) {
            InventoryCacheDto eo = new InventoryCacheDto(this.getWarehouseClassify());
            eo.setKey(key);
            eo.setFiled(CsInventoryLocationEnum.AVAILABLE.getCode());
            eo.setValue(available);
            eo.setGroup(group);
            eo.setValidate(this.getNegativeValidate());
            eo.setLowerLimit(this.getLowerLimit());
            eo.setUpLimit(this.getUpperLimit());
            objs.add(eo);
        }
        return objs;
    }

    @JSONField(serialize=false)
    private List<InventoryCacheDto> getSearchInventoryCache() {
        ArrayList<InventoryCacheDto> objs = new ArrayList<InventoryCacheDto>();
        String key = this.getWarehouseCode() + ":" + this.getSkuCode();
        String group = "_inventory";
        if (CollectionUtils.isEmpty(this.searchLocations)) {
            InventoryCacheDto eo = new InventoryCacheDto(this.getWarehouseClassify());
            eo.setKey(key);
            eo.setFiled(CsInventoryLocationEnum.AVAILABLE.getCode());
            eo.setValue(this.available);
            eo.setGroup(group);
            objs.add(eo);
        }
        this.searchLocations.stream().forEach(locationEnum -> {
            InventoryCacheDto eo = new InventoryCacheDto(this.getWarehouseClassify());
            eo.setGroup(group);
            eo.setKey(key);
            eo.setFiled(locationEnum.getCode());
            objs.add(eo);
        });
        return objs;
    }

    @JSONField(serialize=false)
    public String[] getInventoryCacheKeys() {
        return (String[])this.getInventoryCache().stream().map(InventoryCacheDto::getCacheKey).toArray(String[]::new);
    }

    @JSONField(serialize=false)
    public void setBValue(String location, BigDecimal value) throws NoSuchFieldException, IllegalAccessException {
        this.getClass().getDeclaredField(location + "_b").set(this, value);
    }

    @JSONField(serialize=false)
    public void setEValue(String location, BigDecimal value) throws NoSuchFieldException, IllegalAccessException {
        this.getClass().getDeclaredField(location + "_e").set(this, value);
    }

    @JSONField(serialize=false)
    public void setValue(String location, BigDecimal value) throws NoSuchFieldException, IllegalAccessException {
        this.getClass().getDeclaredField(location).set(this, value);
    }

    @JSONField(serialize=false)
    public BigDecimal getAvailableQuantity() {
        BigDecimal insertAvailableInventory = BigDecimal.ZERO;
        if (null != this.getBalance()) {
            insertAvailableInventory = insertAvailableInventory.add(this.getBalance());
        }
        if (null != this.getPreempt()) {
            insertAvailableInventory = insertAvailableInventory.subtract(this.getPreempt());
        }
        if (null != this.getAllocate()) {
            insertAvailableInventory = insertAvailableInventory.subtract(this.getAllocate());
        }
        return insertAvailableInventory;
    }

    @JSONField(serialize=false)
    public void inventoryNegate() {
        this.setNegativeValidate(0);
        if (null != this.getBalance()) {
            this.setBalance(this.getBalance().negate());
        }
        if (null != this.getPreempt()) {
            this.setPreempt(this.getPreempt().negate());
        }
        if (null != this.getAllocate()) {
            this.setAllocate(this.getAllocate().negate());
        }
    }

    public static List<String> getLoopByField(List<CsInventorySourceDto> reqs, String fieldName) {
        ArrayList<String> fields = new ArrayList<String>();
        reqs.forEach(req -> {
            String value = CsInventorySourceDto.getFieldValue(req, fieldName);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                fields.add(value);
            }
            if (CollectionUtils.isNotEmpty(req.getSourceDtos())) {
                fields.addAll(CsInventorySourceDto.getLoopByField(req.getSourceDtos(), fieldName));
            }
        });
        return fields;
    }

    public static String getFieldValue(CsInventorySourceDto req, String fieldName) {
        try {
            Field field = CsInventorySourceDto.class.getSuperclass().getSuperclass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return String.valueOf(field.get(req));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<CsInventoryLocationEnum> getSearchLocations() {
        return this.searchLocations;
    }

    public String getInOutFlag() {
        return this.inOutFlag;
    }

    public BigDecimal getBalance_b() {
        return this.balance_b;
    }

    public BigDecimal getPreempt_b() {
        return this.preempt_b;
    }

    public BigDecimal getAllocate_b() {
        return this.allocate_b;
    }

    public BigDecimal getAvailable_b() {
        return this.available_b;
    }

    public BigDecimal getBalance_e() {
        return this.balance_e;
    }

    public BigDecimal getPreempt_e() {
        return this.preempt_e;
    }

    public BigDecimal getAllocate_e() {
        return this.allocate_e;
    }

    public BigDecimal getAvailable_e() {
        return this.available_e;
    }

    public List<CsInventorySourceDto> getSourceDtos() {
        return this.sourceDtos;
    }

    public void setSearchLocations(List<CsInventoryLocationEnum> searchLocations) {
        this.searchLocations = searchLocations;
    }

    public void setInOutFlag(String inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public void setBalance_b(BigDecimal balance_b) {
        this.balance_b = balance_b;
    }

    public void setPreempt_b(BigDecimal preempt_b) {
        this.preempt_b = preempt_b;
    }

    public void setAllocate_b(BigDecimal allocate_b) {
        this.allocate_b = allocate_b;
    }

    public void setAvailable_b(BigDecimal available_b) {
        this.available_b = available_b;
    }

    public void setBalance_e(BigDecimal balance_e) {
        this.balance_e = balance_e;
    }

    public void setPreempt_e(BigDecimal preempt_e) {
        this.preempt_e = preempt_e;
    }

    public void setAllocate_e(BigDecimal allocate_e) {
        this.allocate_e = allocate_e;
    }

    public void setAvailable_e(BigDecimal available_e) {
        this.available_e = available_e;
    }

    public void setSourceDtos(List<CsInventorySourceDto> sourceDtos) {
        this.sourceDtos = sourceDtos;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsInventorySourceDto)) {
            return false;
        }
        CsInventorySourceDto other = (CsInventorySourceDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CsInventoryLocationEnum> this$searchLocations = this.getSearchLocations();
        List<CsInventoryLocationEnum> other$searchLocations = other.getSearchLocations();
        if (this$searchLocations == null ? other$searchLocations != null : !((Object)this$searchLocations).equals(other$searchLocations)) {
            return false;
        }
        String this$inOutFlag = this.getInOutFlag();
        String other$inOutFlag = other.getInOutFlag();
        if (this$inOutFlag == null ? other$inOutFlag != null : !this$inOutFlag.equals(other$inOutFlag)) {
            return false;
        }
        BigDecimal this$balance_b = this.getBalance_b();
        BigDecimal other$balance_b = other.getBalance_b();
        if (this$balance_b == null ? other$balance_b != null : !((Object)this$balance_b).equals(other$balance_b)) {
            return false;
        }
        BigDecimal this$preempt_b = this.getPreempt_b();
        BigDecimal other$preempt_b = other.getPreempt_b();
        if (this$preempt_b == null ? other$preempt_b != null : !((Object)this$preempt_b).equals(other$preempt_b)) {
            return false;
        }
        BigDecimal this$allocate_b = this.getAllocate_b();
        BigDecimal other$allocate_b = other.getAllocate_b();
        if (this$allocate_b == null ? other$allocate_b != null : !((Object)this$allocate_b).equals(other$allocate_b)) {
            return false;
        }
        BigDecimal this$available_b = this.getAvailable_b();
        BigDecimal other$available_b = other.getAvailable_b();
        if (this$available_b == null ? other$available_b != null : !((Object)this$available_b).equals(other$available_b)) {
            return false;
        }
        BigDecimal this$balance_e = this.getBalance_e();
        BigDecimal other$balance_e = other.getBalance_e();
        if (this$balance_e == null ? other$balance_e != null : !((Object)this$balance_e).equals(other$balance_e)) {
            return false;
        }
        BigDecimal this$preempt_e = this.getPreempt_e();
        BigDecimal other$preempt_e = other.getPreempt_e();
        if (this$preempt_e == null ? other$preempt_e != null : !((Object)this$preempt_e).equals(other$preempt_e)) {
            return false;
        }
        BigDecimal this$allocate_e = this.getAllocate_e();
        BigDecimal other$allocate_e = other.getAllocate_e();
        if (this$allocate_e == null ? other$allocate_e != null : !((Object)this$allocate_e).equals(other$allocate_e)) {
            return false;
        }
        BigDecimal this$available_e = this.getAvailable_e();
        BigDecimal other$available_e = other.getAvailable_e();
        if (this$available_e == null ? other$available_e != null : !((Object)this$available_e).equals(other$available_e)) {
            return false;
        }
        List<CsInventorySourceDto> this$sourceDtos = this.getSourceDtos();
        List<CsInventorySourceDto> other$sourceDtos = other.getSourceDtos();
        return !(this$sourceDtos == null ? other$sourceDtos != null : !((Object)this$sourceDtos).equals(other$sourceDtos));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CsInventorySourceDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CsInventoryLocationEnum> $searchLocations = this.getSearchLocations();
        result = result * 59 + ($searchLocations == null ? 43 : ((Object)$searchLocations).hashCode());
        String $inOutFlag = this.getInOutFlag();
        result = result * 59 + ($inOutFlag == null ? 43 : $inOutFlag.hashCode());
        BigDecimal $balance_b = this.getBalance_b();
        result = result * 59 + ($balance_b == null ? 43 : ((Object)$balance_b).hashCode());
        BigDecimal $preempt_b = this.getPreempt_b();
        result = result * 59 + ($preempt_b == null ? 43 : ((Object)$preempt_b).hashCode());
        BigDecimal $allocate_b = this.getAllocate_b();
        result = result * 59 + ($allocate_b == null ? 43 : ((Object)$allocate_b).hashCode());
        BigDecimal $available_b = this.getAvailable_b();
        result = result * 59 + ($available_b == null ? 43 : ((Object)$available_b).hashCode());
        BigDecimal $balance_e = this.getBalance_e();
        result = result * 59 + ($balance_e == null ? 43 : ((Object)$balance_e).hashCode());
        BigDecimal $preempt_e = this.getPreempt_e();
        result = result * 59 + ($preempt_e == null ? 43 : ((Object)$preempt_e).hashCode());
        BigDecimal $allocate_e = this.getAllocate_e();
        result = result * 59 + ($allocate_e == null ? 43 : ((Object)$allocate_e).hashCode());
        BigDecimal $available_e = this.getAvailable_e();
        result = result * 59 + ($available_e == null ? 43 : ((Object)$available_e).hashCode());
        List<CsInventorySourceDto> $sourceDtos = this.getSourceDtos();
        result = result * 59 + ($sourceDtos == null ? 43 : ((Object)$sourceDtos).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CsInventorySourceDto(searchLocations=" + this.getSearchLocations() + ", inOutFlag=" + this.getInOutFlag() + ", balance_b=" + this.getBalance_b() + ", preempt_b=" + this.getPreempt_b() + ", allocate_b=" + this.getAllocate_b() + ", available_b=" + this.getAvailable_b() + ", balance_e=" + this.getBalance_e() + ", preempt_e=" + this.getPreempt_e() + ", allocate_e=" + this.getAllocate_e() + ", available_e=" + this.getAvailable_e() + ", sourceDtos=" + this.getSourceDtos() + ")";
    }
}

