/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.util.ReflectionUtils;
import com.dtyunxi.yundt.cube.center.inventory.share.exception.InventoryShareExceptionCode;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class Assert
extends com.dtyunxi.cube.biz.commons.utils.Assert {
    public static final String CODE = "inventory.share-";

    public static void isTrue(boolean expression, InventoryShareExceptionCode inventoryExceptionCode) {
        if (!expression) {
            Assert.throwException(inventoryExceptionCode);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new BizException(CODE + ExceptionCode.FAIL.getCode(), message);
        }
    }

    public static void notNull(@Nullable Object object, InventoryShareExceptionCode inventoryExceptionCode) {
        Assert.notNull(object, inventoryExceptionCode, "");
    }

    public static void notNull(@Nullable Object object, InventoryShareExceptionCode inventoryExceptionCode, String extMsg) {
        if (object == null) {
            Assert.throwException(inventoryExceptionCode, extMsg);
        }
    }

    public static void notBlank(@Nullable String object, InventoryShareExceptionCode inventoryExceptionCode) {
        if (StringUtils.isBlank((CharSequence)object)) {
            Assert.throwException(inventoryExceptionCode);
        }
    }

    public static void notEmpty(@Nullable Collection<?> coll, InventoryShareExceptionCode inventoryExceptionCode) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(coll)) {
            Assert.throwException(inventoryExceptionCode);
        }
    }

    public static void isEmpty(@Nullable Collection<?> coll, InventoryShareExceptionCode inventoryExceptionCode) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(coll)) {
            Assert.throwException(inventoryExceptionCode);
        }
    }

    public static String throwException(InventoryShareExceptionCode inventoryExceptionCode) {
        return Assert.throwException(inventoryExceptionCode, "");
    }

    public static String throwException(InventoryShareExceptionCode inventoryExceptionCode, String extMsg) {
        String code = CODE + inventoryExceptionCode.getCode();
        throw new BizException(code, inventoryExceptionCode.getMsg() + extMsg);
    }

    public static void emptyValidated(Object obj, String ... fields) {
        Assert.isTrue((obj != null ? 1 : 0) != 0, (String)ExceptionCode.INVALID_PARAM.getCode(), (String)ExceptionCode.INVALID_PARAM.getMsg());
        for (String field : fields) {
            Object fieldValue = ReflectionUtils.getFieldValue((Object)obj, (String)field);
            boolean expression = true;
            boolean bl = expression = fieldValue != null;
            if (expression) {
                if (fieldValue instanceof String) {
                    expression = StringUtils.isNotBlank((CharSequence)((String)fieldValue));
                } else if (fieldValue instanceof Short) {
                    expression = (Short)fieldValue > 0;
                } else if (fieldValue instanceof Integer) {
                    expression = (Integer)fieldValue > 0;
                } else if (fieldValue instanceof Long) {
                    expression = (Long)fieldValue > 0L;
                } else if (fieldValue instanceof Float) {
                    expression = ((Float)fieldValue).floatValue() > 0.0f;
                } else if (fieldValue instanceof Double) {
                    expression = (Double)fieldValue > 0.0;
                } else if (fieldValue instanceof BigDecimal) {
                    expression = ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) > 0;
                } else if (fieldValue instanceof Collection) {
                    expression = !CollectionUtils.isEmpty((Collection)((Collection)fieldValue));
                } else if (fieldValue instanceof Map) {
                    expression = !CollectionUtils.isEmpty((Map)((Map)fieldValue));
                }
            }
            Assert.isTrue((boolean)expression, (String)ExceptionCode.INVALID_PARAM.getCode(), (String)(field + ExceptionCode.INVALID_PARAM.getMsg()));
        }
    }
}

