/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.center.message.api.dto.request;

import com.dtyunxi.yundt.center.message.api.dto.request.MessageReqDto;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class MessageTargetMapReqDto
implements Serializable {
    private static final long serialVersionUID = 7927760528833064463L;
    private List<MessageTargetMap> targetMapList;

    public List<MessageTargetMap> getTargetMapList() {
        return this.targetMapList;
    }

    public void setTargetMapList(List<MessageTargetMap> targetMapList) {
        this.targetMapList = targetMapList;
    }

    public static MessageTargetMap buildTargetMap(Long relationId, Integer source, List<Long> memberIds) {
        MessageTargetMap messageTargetMap = new MessageTargetMap();
        messageTargetMap.setMemberIds(memberIds);
        messageTargetMap.setRelationId(relationId);
        messageTargetMap.setSource(source);
        return messageTargetMap;
    }

    public static MessageTargetMapReqDto init() {
        MessageTargetMapReqDto messageTargetMapReqDto = new MessageTargetMapReqDto();
        messageTargetMapReqDto.targetMapList = new ArrayList<MessageTargetMap>();
        return messageTargetMapReqDto;
    }

    public static void append(Long relationId, Integer source, Long memberId, MessageReqDto messageReqDto) {
        MessageTargetMapReqDto messageTargetMapReqDto;
        HashMap<String, MessageTargetMapReqDto> ext = messageReqDto.getExtFields();
        if (ext == null) {
            ext = new HashMap<String, MessageTargetMapReqDto>();
            messageReqDto.setExtFields(ext);
        }
        if (ext.containsKey("MESSAGE_TARGET_MEMBER")) {
            messageTargetMapReqDto = (MessageTargetMapReqDto)ext.get("MESSAGE_TARGET_MEMBER");
        } else {
            messageTargetMapReqDto = MessageTargetMapReqDto.init();
            ext.put("MESSAGE_TARGET_MEMBER", messageTargetMapReqDto);
        }
        List<MessageTargetMap> list = messageTargetMapReqDto.getTargetMapList();
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList<MessageTargetMap>();
            messageTargetMapReqDto.setTargetMapList(list);
            MessageTargetMap messageTargetMap = new MessageTargetMap(relationId, source, Collections.singletonList(memberId));
            list.add(messageTargetMap);
        } else {
            list.get(0).getMemberIds().add(memberId);
        }
    }

    public static class MessageTargetMap {
        @ApiModelProperty(value="\u6765\u6e90\u5173\u8054\u5bf9\u8c61id\uff08\u4e8b\u4ef6\u8425\u9500\u6216\u8005\u4e3b\u52a8\u8425\u9500\uff09")
        private Long relationId;
        @ApiModelProperty(value="\u6d88\u606f\u53d1\u9001\u6765\u6e90\uff080:\u4e3b\u52a8\u8425\u9500 1:\u4e8b\u4ef6\u8425\u9500\uff09")
        private Integer source;
        @ApiModelProperty(value="\u4f1a\u5458id\u5217\u8868")
        private List<Long> memberIds;

        public Long getRelationId() {
            return this.relationId;
        }

        public void setRelationId(Long relationId) {
            this.relationId = relationId;
        }

        public Integer getSource() {
            return this.source;
        }

        public void setSource(Integer source) {
            this.source = source;
        }

        public List<Long> getMemberIds() {
            return this.memberIds;
        }

        public void setMemberIds(List<Long> memberIds) {
            this.memberIds = memberIds;
        }

        public MessageTargetMap() {
        }

        public MessageTargetMap(Long relationId, Integer source, List<Long> memberIds) {
            this.relationId = relationId;
            this.source = source;
            this.memberIds = memberIds;
        }
    }
}

