/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.cube.center.user.api.dto.ext.user.UserUniqueCheckDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.constant.IdentityConstants;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAuthorizeService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.LoginConfigDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.LoginConfigEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.ext.user.IUserUniquenessExt;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorizeServiceImpl
implements IAuthorizeService {
    private Logger logger = LoggerFactory.getLogger(AuthorizeServiceImpl.class);
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private UserDas userDas;
    @Autowired
    private LoginConfigDas loginConfigDas;
    @Resource
    private IApplicationService applicationService;
    @Autowired
    private IUserUniquenessExt<Boolean, UserUniqueCheckDto> userUniquenessExt;
    @Value(value="${cube.identity.verifycode.smsTemplateCode}")
    private String smsTemplateCode;
    @Value(value="${cube.identity.verifycode.smsTplParamCode}")
    private String smsTplParamCode;
    @Value(value="${cube.identity.verifycode.emailSender}")
    private String emailSender;
    @Value(value="${cube.identity.verifycode.emailTemplateCode}")
    private String emailTemplateCode;
    @Value(value="${cube.identity.verifycode.emailTplParamCode}")
    private String emailTplParamCode;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long bindPhone(Long instanceId, Long userId, String phone) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u5b9e\u4f8b");
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (userEo == null) {
            this.logger.info("\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
            throw new BizException(UserExceptionCode.USERNAME_CHECK_FAIL.getCode(), UserExceptionCode.USERNAME_CHECK_FAIL.getMsg());
        }
        boolean b = (Boolean)this.userUniquenessExt.execute((Object)UserUniqueCheckDto.init(null, (Long)instanceId, null, (String)"phone", (Object)phone));
        AssertUtil.isTrue(!b, "\u624b\u673a\u53f7\u7801\u5df2\u88ab\u6ce8\u518c");
        userEo.setPhone(phone);
        userEo.setInstanceId(instanceId);
        userEo.setTenantId(tenantId);
        this.userDas.update((BaseEo)userEo);
        LoginConfigEo loginConfigEo = new LoginConfigEo();
        loginConfigEo.setOwnerId(userId);
        loginConfigEo.setLoginType(IdentityConstants.LoginType.phone.getCode());
        LoginConfigEo tmpEo = (LoginConfigEo)this.loginConfigDas.selectOne((BaseEo)loginConfigEo);
        if (null == tmpEo) {
            loginConfigEo.setStatus(Integer.valueOf(1));
            loginConfigEo.setLoginKey(phone);
            loginConfigEo.setTenantId(tenantId);
            loginConfigEo.setInstanceId(instanceId);
            this.loginConfigDas.insert((BaseEo)loginConfigEo);
        } else {
            loginConfigEo.setId(tmpEo.getId());
            loginConfigEo.setLoginKey(phone);
            this.loginConfigDas.updateSelective((BaseEo)loginConfigEo);
        }
        return userEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long unbindPhone(Long instanceId, Long userId, String phone) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u5b9e\u4f8b");
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (userEo == null) {
            this.logger.info("\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
            throw new BizException(UserExceptionCode.USERNAME_CHECK_FAIL.getCode(), UserExceptionCode.USERNAME_CHECK_FAIL.getMsg());
        }
        userEo.setPhone(null);
        appInstanceEo.setTenantId(tenantId);
        userEo.setTenantId(tenantId);
        this.userDas.update((BaseEo)userEo);
        LoginConfigEo loginConfigEo = new LoginConfigEo();
        loginConfigEo.setOwnerId(userId);
        loginConfigEo.setLoginType(IdentityConstants.LoginType.phone.getCode());
        LoginConfigEo tmpEo = (LoginConfigEo)this.loginConfigDas.selectOne((BaseEo)loginConfigEo);
        if (null != tmpEo) {
            this.loginConfigDas.logicDelete((BaseEo)tmpEo);
        }
        return userEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long bindEmail(Long instanceId, Long userId, String email) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u5b9e\u4f8b");
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (userEo == null) {
            this.logger.info("\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
            throw new BizException(UserExceptionCode.USERNAME_CHECK_FAIL.getCode(), UserExceptionCode.USERNAME_CHECK_FAIL.getMsg());
        }
        boolean b = (Boolean)this.userUniquenessExt.execute((Object)UserUniqueCheckDto.init(null, (Long)instanceId, null, (String)"email", (Object)email));
        AssertUtil.isTrue(!b, "\u90ae\u4ef6\u5730\u5740\u5df2\u88ab\u6ce8\u518c");
        userEo.setEmail(email);
        userEo.setTenantId(tenantId);
        this.userDas.update((BaseEo)userEo);
        LoginConfigEo loginConfigEo = new LoginConfigEo();
        loginConfigEo.setOwnerId(userId);
        loginConfigEo.setLoginType(IdentityConstants.LoginType.email.getCode());
        LoginConfigEo tmpEo = (LoginConfigEo)this.loginConfigDas.selectOne((BaseEo)loginConfigEo);
        if (null == tmpEo) {
            loginConfigEo.setStatus(Integer.valueOf(1));
            loginConfigEo.setLoginKey(email);
            loginConfigEo.setTenantId(tenantId);
            this.loginConfigDas.insert((BaseEo)loginConfigEo);
        } else {
            loginConfigEo.setId(tmpEo.getId());
            loginConfigEo.setLoginKey(email);
            this.loginConfigDas.updateSelective((BaseEo)loginConfigEo);
        }
        return userEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long unbindEmail(Long instanceId, Long userId, String email) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u5b9e\u4f8b");
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (userEo == null) {
            this.logger.info("\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
            throw new BizException(UserExceptionCode.USERNAME_CHECK_FAIL.getCode(), UserExceptionCode.USERNAME_CHECK_FAIL.getMsg());
        }
        userEo.setEmail(null);
        userEo.setTenantId(tenantId);
        this.userDas.update((BaseEo)userEo);
        LoginConfigEo loginConfigEo = new LoginConfigEo();
        loginConfigEo.setOwnerId(userId);
        loginConfigEo.setLoginType(IdentityConstants.LoginType.email.getCode());
        LoginConfigEo tmpEo = (LoginConfigEo)this.loginConfigDas.selectOne((BaseEo)loginConfigEo);
        if (null != tmpEo) {
            this.loginConfigDas.logicDelete((BaseEo)tmpEo);
        }
        return userEo.getId();
    }
}

