/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.IBizSpaceApi;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.constant.TenantStatusEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.ITenantService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.RegisterConfigDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.TenantDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDomainDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RegisterConfigEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.TenantEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserDomainEo;
import com.dtyunxi.yundt.cube.center.user.ext.tenant.ITenantAfterRegisterExt;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantServiceImpl
implements ITenantService {
    private Logger logger = LoggerFactory.getLogger(TenantServiceImpl.class);
    public static String REDIS_KEY_PREFIX = "TenantServiceImpl.queryById:id:";
    @Autowired
    private TenantDas tenantDas;
    @Autowired
    private RegisterConfigDas registerConfigDas;
    @Autowired
    private IApplicationService applicationService;
    @Autowired(required=false)
    private IBizSpaceApi bizSpaceApi;
    @CubeResource
    private ITenantAfterRegisterExt tenantAfterRegisterExt;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private UserDomainDas userDomainDas;

    @Override
    public PageInfo<TenantDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TenantEo tenantEo = QueryUtil.validateExampleAndReturn(filter, TenantEo.class);
        tenantEo.setOrderByDesc("update_time");
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)tenantEo.getTenantCode())) {
            filters.add(SqlFilter.like((String)"tenantCode", (Object)("%" + tenantEo.getTenantCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)tenantEo.getTenantName())) {
            filters.add(SqlFilter.like((String)"tenantName", (Object)("%" + tenantEo.getTenantName() + "%")));
        }
        tenantEo.setSqlFilters(filters);
        PageInfo page = this.tenantDas.selectPage((BaseEo)tenantEo, pageNum, pageSize);
        ArrayList<TenantDto> tenantDtos = new ArrayList<TenantDto>();
        for (TenantEo eo : page.getList()) {
            TenantDto tenantDto = new TenantDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)tenantDto);
            Set<String> availableDomains = this.tenantAvailableDomainStringToSet(eo.getAvailableDomain());
            tenantDto.setAvailableDomain(availableDomains);
            tenantDtos.add(tenantDto);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(tenantDtos);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addTenant(TenantDto tenantDto) {
        if (StringUtils.isNotBlank((CharSequence)tenantDto.getTenantCode())) {
            TenantEo eo = new TenantEo();
            eo.setTenantCode(tenantDto.getTenantCode());
            if (this.tenantDas.count((BaseEo)eo) > 0) {
                throw new BizException("11001", "\u79df\u6237\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        this.checkTenantName(tenantDto.getId(), tenantDto.getTenantName());
        TenantEo tenantEo = new TenantEo();
        DtoHelper.dto2Eo((BaseVo)tenantDto, (BaseEo)tenantEo);
        tenantEo.setStatus(TenantStatusEnum.INIT.getKey());
        this.tenantDas.insert((BaseEo)tenantEo);
        Long tenantId = tenantEo.getId();
        tenantDto.setId(tenantId);
        this.commonsMqService.publishMessage("TENANT-INIT", (Object)tenantDto);
        UserDomainEo userDomainEo = new UserDomainEo();
        userDomainEo.setCode("default");
        userDomainEo.setName("\u9ed8\u8ba4");
        userDomainEo.setTenantId(tenantId);
        this.userDomainDas.insert((BaseEo)userDomainEo);
        return tenantId;
    }

    private String addBizSpace(Long tenantId) {
        BizSpaceCreateReqDto bizSpaceCreateReqDto = new BizSpaceCreateReqDto();
        bizSpaceCreateReqDto.setCode("default");
        bizSpaceCreateReqDto.setName("\u9ed8\u8ba4\u4e1a\u52a1\u7a7a\u95f4");
        bizSpaceCreateReqDto.setTenantId(tenantId);
        bizSpaceCreateReqDto.setStatus(Integer.valueOf(1));
        RestResponse restResponse = this.bizSpaceApi.addBizSpace(bizSpaceCreateReqDto);
        String bizSpaceCode = null;
        if (restResponse != null && StringUtils.isNotBlank((CharSequence)((CharSequence)restResponse.getData()))) {
            bizSpaceCode = (String)restResponse.getData();
        }
        return bizSpaceCode;
    }

    @Override
    public void updateTenant(TenantDto tenantDto) {
        AssertUtil.isTrue(null != tenantDto.getId(), "\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkTenantName(tenantDto.getId(), tenantDto.getTenantName());
        TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantDto.getId());
        DtoHelper.dto2Eo((BaseVo)tenantDto, (BaseEo)tenantEo, (String[])new String[]{"tenantId", "tenantCode", "instanceId"});
        this.tenantDas.update((BaseEo)tenantEo);
        this.cacheService.delCache(REDIS_KEY_PREFIX + tenantDto.getId());
    }

    @Override
    public void initTenant(TenantDto tenantDto) {
        Long tenantId = tenantDto.getId();
        String bizSpaceCode = this.addBizSpace(tenantId);
        this.applicationService.addBocInstance(tenantId, bizSpaceCode);
        this.applicationService.addMpcInstance(tenantId, bizSpaceCode);
        TenantEo updateEo = new TenantEo();
        updateEo.setId(tenantId);
        updateEo.setStatus(TenantStatusEnum.ENABLED.getKey());
        this.tenantDas.updateSelective((BaseEo)updateEo);
        this.tenantAfterRegisterExt.addTenantManager(tenantDto);
    }

    private void checkTenantName(Long tenantId, String tenantName) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)tenantName), "\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        TenantEo eo = new TenantEo();
        eo.setTenantName(tenantName);
        if (tenantId != null) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.ne((String)"id", (Object)tenantId));
            eo.setSqlFilters(sqlFilters);
        }
        if (this.tenantDas.count((BaseEo)eo) > 0) {
            throw new BizException("11001", "\u79df\u6237\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    @Override
    public void enableTenant(Long tenantId) {
        AssertUtil.isTrue(null != tenantId, "\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId);
        AssertUtil.isTrue(null != tenantEo, "\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728 | tenantId = " + tenantId);
        AssertUtil.isTrue(TenantStatusEnum.DISABLED.getKey() - tenantEo.getStatus() == 0, "\u79df\u6237\u72b6\u6001\u4e0d\u6b63\u786e");
        TenantEo updateEo = new TenantEo();
        updateEo.setId(tenantId);
        updateEo.setStatus(TenantStatusEnum.ENABLED.getKey());
        this.tenantDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void disableTenant(Long tenantId) {
        AssertUtil.isTrue(null != tenantId, "\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId);
        AssertUtil.isTrue(null != tenantEo, "\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728 | tenantId = " + tenantId);
        AssertUtil.isTrue(TenantStatusEnum.ENABLED.getKey() - tenantEo.getStatus() == 0, "\u79df\u6237\u72b6\u6001\u4e0d\u6b63\u786e");
        TenantEo updateEo = new TenantEo();
        updateEo.setId(tenantId);
        updateEo.setStatus(TenantStatusEnum.DISABLED.getKey());
        this.tenantDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public TenantDto queryByUserId(Long userId) {
        TenantEo tenantEo = this.tenantDas.findByUserId(userId);
        AssertUtil.isTrue(null != tenantEo, "\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728 | \u5f52\u5c5e\u7528\u6237userId = " + userId);
        TenantDto tenantDto = new TenantDto();
        DtoHelper.eo2Dto((BaseEo)tenantEo, (BaseVo)tenantDto);
        Set<String> availableDomains = this.tenantAvailableDomainStringToSet(tenantEo.getAvailableDomain());
        tenantDto.setAvailableDomain(availableDomains);
        return tenantDto;
    }

    @Override
    public TenantDto queryById(Long id) {
        String redisKey = REDIS_KEY_PREFIX + id;
        TenantDto cache = (TenantDto)this.cacheService.getCache(redisKey, TenantDto.class);
        if (cache != null) {
            return cache;
        }
        TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(id);
        if (tenantEo == null) {
            return null;
        }
        RegisterConfigEo registerConfigEo = this.registerConfigDas.findConfigByTenantId(id);
        if (registerConfigEo != null) {
            tenantEo.setIsolation(registerConfigEo.getIsolationType());
        }
        TenantDto tenantDto = new TenantDto();
        DtoHelper.eo2Dto((BaseEo)tenantEo, (BaseVo)tenantDto);
        Set<String> availableDomains = this.tenantAvailableDomainStringToSet(tenantEo.getAvailableDomain());
        tenantDto.setAvailableDomain(availableDomains);
        this.cacheService.setCache(redisKey, (Object)tenantDto);
        return tenantDto;
    }

    @Override
    public TenantDto queryTenantByInstanceId(Long instanceId) {
        TenantDto tenantDto = null;
        AppInstanceDto appInstanceDto = this.applicationService.queryInstanceOne(instanceId);
        if (appInstanceDto != null && (tenantDto = this.queryById(appInstanceDto.getTenantId())) != null) {
            tenantDto.setAppInstanceDto(appInstanceDto);
        }
        return tenantDto;
    }

    private Set<String> tenantAvailableDomainStringToSet(String availableDomain) {
        HashSet<String> trustDomainSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)availableDomain)) {
            trustDomainSet.addAll(Arrays.asList(availableDomain.split(",")));
        }
        return trustDomainSet;
    }
}

