/*
 * @(#)IDictApi.java1.0 2018年7月17日
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.dtyunxi.yundt.cube.center.func.api;


import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ConfigImportDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 扩展点Command(CQRS)接口
 *
 * @author youyang
 * @see ISettingApi
 * @since 2.6.21.0
 */
@Api(tags = {"基础数据中心：配置项管理：扩展点服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IBizExtensionApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v2/biz-extension", url = "${yundt.cube.center.data.api:}")
public interface IBizExtensionApi {

    /**
     * 新增业务扩展点信息.
     *
     * @param addReqDto .请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增业务扩展点信息. ", notes = "新增业务扩展点信息")
    @Capability(capabilityCode = "basicdata.biz-extension.add-biz-extension")
    RestResponse<String> addBizExtension(@RequestBody BizExtensionCreateReqDto addReqDto);

    /**
     * 新增业务扩展点信息.
     *
     * @param importReqDtoList 请求对象
     * @return 处理结果
     */
    @PostMapping("/batch")
    @ApiOperation(value = "批量新增业务扩展点信息. ", notes = "批量新增业务扩展点信息")
    @Capability(capabilityCode = "basicdata.biz-extension.import-biz-extension")
    RestResponse<ConfigImportDto> importBizExtension(@RequestBody List<BizExtensionCreateReqDto> importReqDtoList,
                                                     @RequestParam(value = "portion", required = false) Integer portion);

    /**
     * 修改业务扩展点信息.
     *
     * @param modifyReqDto 业务扩展点信息.请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改业务扩展点信息. ", notes = "修改业务扩展点信息. ")
    @Capability(capabilityCode = "basicdata.biz-extension.modify-biz-extension")
    RestResponse<Void> modifyBizExtension(@RequestBody BizExtensionModifyReqDto modifyReqDto);

    /**
     * 删除业务扩展点信息.
     *
     * @param bextCode 删除数据code
     * @return 处理结果
     */
    @DeleteMapping("")
    @ApiOperation(value = "删除业务扩展点信息. ", notes = "删除业务扩展点信息. ")
    @Capability(capabilityCode = "basicdata.biz-extension.remove-biz-extension")
    RestResponse<Void> removeBizExtension(@SpringQueryMap BizExtensionRemoveDto bextCode);

    /**
     * 新增业务扩展点实现信息.
     *
     * @param bizExtImplCreateReqDto 业务扩展点信息.请求对象
     * @return 处理结果
     */
    @PostMapping("/bextImplCode/")
    @ApiOperation(value = "新增业务扩展点实现信息. ", notes = "新增业务扩展点实现信息. ")
    @Capability(capabilityCode = "basicdata.biz-extension.add-biz-ext-impl")
    RestResponse<String> addBizExtImpl(@RequestBody BizExtImplCreateReqDto bizExtImplCreateReqDto);

    /**
     * 修改业务扩展点实现信息.
     *
     * @param modifyReqDto 业务扩展点信息.请求对象
     * @return 处理结果
     */
    @PutMapping("/bextImplCode")
    @ApiOperation(value = "修改业务扩展点实现信息. ", notes = "修改业务扩展点实现信息. ")
    @Capability(capabilityCode = "basicdata.biz-extension.modify-biz-ext-impl")
    RestResponse<Void> modifyBizExtImpl(@RequestBody BizExtensionImplModifyReqDto modifyReqDto);

    /**
     * 删除业务扩展点信息.
     *
     * @param bizExtImplRemoveDto 删除数据code
     * @return 处理结果
     */
    @DeleteMapping("/bextImpl")
    @ApiOperation(value = "删除业务扩展点实现信息. ", notes = "删除业务扩展点实现信息. ")
    @Capability(capabilityCode = "basicdata.biz-extension.remove-biz-ext-impl")
    RestResponse<Void> removeBizExtImpl(@SpringQueryMap BizExtImplRemoveDto bizExtImplRemoveDto);

    /**
     * 为租户全量设置扩展点具体实现(覆盖方式)
     *
     * @param extImplValueDtoList 扩展点具体实现列表
     * @return 操作结果
     */
    @PostMapping("/value")
    @ApiOperation(value = "为租户全量设置扩展点具体实现(覆盖方式)", notes = "为租户全量设置扩展点具体实现(覆盖方式)")
    @Capability(capabilityCode = "basicdata.biz-extension.set-biz-ext-impl-value")
    RestResponse<Void> setBizExtImplValue(@Valid @RequestBody List<BizExtImplValueReqDto> extImplValueDtoList);
}
