package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjPropertyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.bizobj.BizObjCreateResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.bizobj.BizObjModifyResDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 业务对象服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：业务对象服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IBizObjApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/biz-obj", url = "${yundt.cube.center.data.api:}")
@Validated
public interface IBizObjApi {

    /**
     * 新增业务对象
     *
     * @param addReqDto 业务对象请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增业务对象", notes = "新增业务对象")
    @Capability(capabilityCode = "basicdata.biz-obj.add-biz-obj")
    RestResponse<BizObjCreateResDto> addBizObj(@RequestBody @Validated BizObjCreateReqDto addReqDto);


    /**
     * 修改业务对象
     *
     * @param modifyReqDto 业务对象请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改业务对象", notes = "修改业务对象")
    @Capability(capabilityCode = "basicdata.biz-obj.modify-biz-obj")
    RestResponse<BizObjModifyResDto> modifyBizObj(@RequestBody @Validated BizObjModifyReqDto modifyReqDto);

    /**
     * 修改业务对象状态
     *
     * @param code   编码
     * @param status 状态：0 禁用  1启用
     * @return
     */
    @PutMapping("status")
    @ApiOperation(value = "修改业务对象状态", notes = "修改业务对象状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "业务对象code", dataType = "string", paramType = "query", required = true),
            @ApiImplicitParam(name = "status", value = "状态：0 禁用  1启用", dataType = "int", paramType = "query", required = true)
    })
    @Capability(capabilityCode = "basicdata.biz-obj.modify-biz-obj-status")
    RestResponse<Void> modifyBizObjStatus(@RequestParam("code") String code, @RequestParam("status") Integer status);

    /**
     * 业务对象关联领域
     *
     * @param code             编码
     * @param abilityGroupCode 领域编码
     * @return
     */
    @PutMapping("ability-group")
    @ApiOperation(value = "关联领域", notes = "关联领域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "业务对象编码", dataType = "string", paramType = "query", required = true),
            @ApiImplicitParam(name = "abilityGroupCode", value = "领域编码,传null代表不绑定", dataType = "string", paramType = "query")
    })
    @Capability(capabilityCode = "basicdata.biz-obj.link-ability-group")
    RestResponse<Void> linkAbilityGroup(@NotBlank(message = "业务对象编码不能为空") @RequestParam("code") String code,
                                        @RequestParam(value = "abilityGroupCode", required = false) String abilityGroupCode);

    /**
     * 修改业务对象属性
     *
     * @param modifyReqDto 业务对象属性请求对象
     * @return 处理结果
     */
    @PutMapping("property")
    @ApiOperation(value = "修改业务对象属性", notes = "修改业务对象属性")
    @Capability(capabilityCode = "basicdata.biz-obj.modify-biz-obj-property")
    RestResponse<Void> modifyBizObjProperty(@RequestBody @Validated BizObjPropertyReqDto modifyReqDto);

    /**
     * 删除业务对象属性
     *
     * @param codes 业务对象属性删除数据codes
     * @return 处理结果
     */
    @DeleteMapping("property")
    @ApiOperation(value = "删除业务对象属性", notes = "删除业务对象属性")
    @Capability(capabilityCode = "basicdata.biz-obj.remove-biz-obj-property")
    RestResponse<Void> removeBizObjProperty(@RequestParam("codes") List<String> codes);
}
