package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 业务空间服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：业务空间服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IBizSpaceApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/biz-space", url = "${yundt.cube.center.data.api:}")
public interface IBizSpaceApi {

    /**
     * 新增业务空间
     *
     * @param bizSpaceCreateReqDto 业务空间请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增业务空间", notes = "新增业务空间")
    @Capability(capabilityCode = "basicdata.biz-space.add-biz-space")
    RestResponse<String> addBizSpace(@Valid @RequestBody BizSpaceCreateReqDto bizSpaceCreateReqDto);

    /**
     * 修改业务空间
     *
     * @param bizSpaceModifyReqDto 业务空间请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改业务空间", notes = "修改业务空间")
    @Capability(capabilityCode = "basicdata.biz-space.modify-biz-space")
    RestResponse<Void> modifyBizSpace(@Valid @RequestBody BizSpaceModifyReqDto bizSpaceModifyReqDto);

    /**
     * 删除业务空间
     *
     * @param bizSpaceReqDto 业务空间删除数据
     * @return 处理结果
     */
    @DeleteMapping("/code")
    @ApiOperation(value = "删除业务空间", notes = "删除业务空间")
    @Capability(capabilityCode = "basicdata.biz-space.remove-biz-space")
    RestResponse<Void> removeBizSpace(@SpringQueryMap BizSpaceReqDto bizSpaceReqDto);


    /**
     * 配置业务空间
     *
     * @param bizSpaceConfigReqDto 业务空间请求对象
     * @return 处理结果
     */
    @PutMapping("/config")
    @ApiOperation(value = "配置业务空间", notes = "配置业务空间")
    @Capability(capabilityCode = "basicdata.biz-space.set-biz-space-config")
    RestResponse<Void> setBizSpaceConfig(@Valid @RequestBody BizSpaceConfigReqDto bizSpaceConfigReqDto);

    /**
     * 设置业务空间关联的配置项的值
     *
     * @param code                          业务空间编码
     * @param bizSpaceConfigValueReqDtoList 配置项值列表
     * @return 操作结果
     */
    @PutMapping("/{code}/config/value")
    @ApiOperation(value = "设置业务空间关联的配置项的值", notes = "设置业务空间关联的配置项的值")
    @Capability(capabilityCode = "basicdata.biz-space.set-biz-space-config-value")
    RestResponse<Void> setBizSpaceConfigValue(@PathVariable("code") String code, @Valid @RequestBody List<BizSpaceConfigValueReqDto> bizSpaceConfigValueReqDtoList);

    /**
     * 新增业务空间-应用实例关系表
     *
     * @param addReqDto 业务空间-应用实例关系表请求对象
     * @return 处理结果
     */
    @PostMapping("/appInstance")
    @ApiOperation(value = "新增业务空间-应用实例关系表", notes = "新增业务空间-应用实例关系表")
    @Capability(capabilityCode = "basicdata.biz-space.add-biz-space-app-instance-relation")
    RestResponse<Long> addBizSpaceAppInstanceRelation(@RequestBody BizSpaceAppInstanceRelationReqDto addReqDto);
}
