/**
 * @(#)IBundleApi 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleModifyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 功能包服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：功能包服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-IBundleApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/bundle", url = "${yundt.cube.center.data.api:}")
public interface IBundleApi {

    /**
     * 新增功能包
     *
     * @param addReqDto 新增功能包的请求对象
     * @return 新增功能包的主键ID
     */
    @PostMapping("")
    @ApiOperation(value = "新增功能包", notes = "新增功能包")
    @Capability(capabilityCode = "basicdata.bundle.add-bundle")
    RestResponse<Long> addBundle(@RequestBody @Valid BundleCreateReqDto addReqDto);

    /**
     * 修改功能包
     *
     * @param modifyReqDto 修改功能包的请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改功能包", notes = "修改功能包")
    @Capability(capabilityCode = "basicdata.bundle.modify-bundle")
    RestResponse<Void> modifyBundle(@RequestBody @Valid BundleModifyReqDto modifyReqDto);

    /**
     * 根据功能包编码删除功能包
     *
     * @param code 功能包编码
     * @return 处理结果
     */
    @DeleteMapping("/by-code/{code}")
    @ApiOperation(value = "删除功能包", notes = "删除功能包")
    @Capability(capabilityCode = "basicdata.bundle.remove-bundle")
    RestResponse<Void> removeBundle(@PathVariable("code") String code);
}
