/**
 * @(#)ISettingApi 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingRemoveReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author shuangqing  2020/2/28
 */
@Api(tags = {"基础数据中心：配置项管理：配置项服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-ISettingApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/setting", url = "${yundt.cube.center.data.api:}")
public interface ISettingApi {
    /**
     * 新增配置项
     *
     * @param settingCreateReqDto 新增配置项请求参数
     * @return 配置项编码
     */
    @PostMapping("")
    @ApiOperation(value = "新增配置项", notes = "新增配置项")
    @Capability(capabilityCode = "basicdata.setting.create-setting")
    RestResponse<String> createSetting(@RequestBody @Valid SettingCreateReqDto settingCreateReqDto);

    /**
     * 修改配置项
     *
     * @param settingModifyReqDto 修改配置项请求参数
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改配置项", notes = "修改配置项")
    @Capability(capabilityCode = "basicdata.setting.modify-setting")
    RestResponse<Void> modifySetting(@RequestBody @Valid SettingModifyReqDto settingModifyReqDto);

    /**
     * 删除配置项信息
     *
     * @param settingRemoveReqDto 删除配置项请求参数
     * @return 处理结果
     */
    @DeleteMapping("")
    @ApiOperation(value = "删除配置项信息", notes = "删除配置项信息")
    @Capability(capabilityCode = "basicdata.setting.remove-setting")
    RestResponse<Void> removeSetting(@SpringQueryMap SettingRemoveReqDto settingRemoveReqDto);
}
