package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingValueReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingViewReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ViewBindSettingDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 配置视图服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：配置视图服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-ISettingViewApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/setting-view", url = "${yundt.cube.center.data.api:}")
public interface ISettingViewApi {

    /**
     * 新增配置视图
     *
     * @param createReqDto 配置视图请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增配置视图", notes = "新增配置视图")
    @Capability(capabilityCode = "basicdata.setting-view.create-setting-view")
    RestResponse<Long> createSettingView(@RequestBody SettingViewReqDto createReqDto);

    /**
     * 修改配置视图
     *
     * @param modifyReqDto 配置视图请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改配置视图", notes = "修改配置视图")
    @Capability(capabilityCode = "basicdata.setting-view.modify-setting-view")
    RestResponse<Void> modifySettingView(@RequestBody SettingViewReqDto modifyReqDto);

    /**
     * 删除配置视图
     *
     * @param id 配置视图删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除配置视图", notes = "删除配置视图")
    @Capability(capabilityCode = "basicdata.setting-view.remove-setting-view")
    RestResponse<Void> removeSettingView(@PathVariable("id") Long id);


    /**
     * 配置视图设置可设定的配置项范围
     *
     * @param viewBindSettingDto 配置视图绑定可设定能力、配置项的范围请求对象
     * @return 处理结果
     */
    @PostMapping("/setting")
    @ApiOperation(value = "配置视图设置可设定的配置项范围", notes = "配置视图设置可设定的配置项范围")
    @Capability(capabilityCode = "basicdata.setting-view.set-setting-in-view")
    RestResponse<String> setSettingInView(@RequestBody ViewBindSettingDto viewBindSettingDto);


    /**
     * 在配置视图设定配置值
     *
     * @param settingValueReqDto 设置配置值dto
     * @return 处理结果
     */
    @PostMapping("/setting-value")
    @ApiOperation(value = "在配置视图设定配置值", notes = "在配置视图设定配置值")
    @Capability(capabilityCode = "basicdata.setting-view.set-setting-value-in-view")
    RestResponse<Void> setSettingValueInView(@RequestBody SettingValueReqDto settingValueReqDto);


}
