/**
 * @(#) ISysParamApi.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ConfigImportDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author 黑马
 * @see ISettingApi
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：配置项管理：业务参数服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-ISysParamApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v2/param", url = "${yundt.cube.center.data.api:}")
@Deprecated
public interface ISysParamApi {

    /**
     * 新增业务参数
     *
     * @param sysParamCreateReqDto 新增业务参数实体
     * @return Long 数据保存后的ID
     */
    @PostMapping
    @ApiOperation(value = "新增业务参数", notes = "新增业务参数")
    @Capability(capabilityCode = "basicdata.sys-param.add-sys-param")
    RestResponse<Long> addSysParam(@Valid @RequestBody SysParamCreateReqDto sysParamCreateReqDto);

    /**
     * 批量导入业务参数
     *
     * @param sysParamCreateReqDtos 批量导入业务参数实体
     * @return
     */
    @PostMapping("/batch")
    @ApiOperation(value = "批量导入业务参数", notes = "批量导入业务参数   portion 是否部分导入，0 否 1 是")
    @Capability(capabilityCode = "basicdata.sys-param.import-sys-param")
    RestResponse<ConfigImportDto> importSysParam(@Valid @RequestBody List<SysParamCreateReqDto> sysParamCreateReqDtos,
                                                 @RequestParam(value = "portion", required = false) Integer portion);

    /**
     * 删除业务参数
     *
     * @param paramCode
     * @return RestResponse&lt;Void&gt;
     */
    @DeleteMapping("")
    @ApiOperation(value = "删除业务参数", notes = "删除业务参数")
    @Capability(capabilityCode = "basicdata.sys-param.delete-sys-param")
    RestResponse<Void> deleteSysParam(@SpringQueryMap SysParamRemoveDto paramCode);

    /**
     * 修改业务参数
     *
     * @param sysParamModifyReqDto 字典
     * @return RestResponse&lt;Void&gt;
     */
    @PutMapping
    @ApiOperation(value = "修改业务参数", notes = "修改业务参数")
    @Capability(capabilityCode = "basicdata.sys-param.modify-sys-param")
    RestResponse<Void> modifySysParam(@Valid @RequestBody SysParamModifyReqDto sysParamModifyReqDto);


    /**
     * 追加加业务参数选项
     *
     * @param paramCode
     * @param sysParamItemDtoList 业务参数可选值清单
     * @return
     */
    @PostMapping("/{paramCode}/item")
    @ApiOperation(value = "增加业务参数选项", notes = "增加业务参数选项")
    @Capability(capabilityCode = "basicdata.sys-param.add-sys-param-item")
    RestResponse<Void> addSysParamItem(@PathVariable("paramCode") String paramCode, @Valid @RequestBody List<SysParamItemReqDto> sysParamItemDtoList);

    /**
     * 全量设置业务参数值(覆盖方式)
     *
     * @param paramCode
     * @param sysParamValueDtoList 业务参数值实体
     * @return
     */
    @PostMapping("/{paramCode}/value")
    @ApiOperation(value = "全量设置业务参数值(覆盖方式)", notes = "全量设置业务参数值(覆盖方式)")
    @Capability(capabilityCode = "basicdata.sys-param.set-sys-param-value")
    RestResponse<Void> setSysParamValue(@PathVariable("paramCode") String paramCode, @Valid @RequestBody List<SysParamValueReqDto> sysParamValueDtoList);


    /**
     * 修改业务参数选项
     *
     * @param paramCode                业务参数编码
     * @param itemCode                 业务参数选项编码
     * @param sysParamItemModifyReqDto 待修改的参数选项
     * @return
     */
    @PutMapping("/param/item")
    @ApiOperation(value = "修改业务参数选项", notes = "修改业务参数选项")
    @Capability(capabilityCode = "basicdata.sys-param.modify-sys-param-item")
    RestResponse<Void> modifySysParamItem(@RequestParam("paramCode") String paramCode,
                                          @RequestParam("itemCode") String itemCode,
                                          @RequestBody SysParamItemModifyReqDto sysParamItemModifyReqDto);

    /**
     * 删除业务参数选项
     *
     * @param paramCode 业务参数编码
     * @param itemCode  业务参数选项编码
     * @return
     */
    @DeleteMapping("/param/item")
    @ApiOperation(value = "删除业务参数选项", notes = "删除业务参数选项")
    @Capability(capabilityCode = "basicdata.sys-param.remove-sys-param-item")
    RestResponse<Void> removeSysParamItem(@RequestParam("paramCode") String paramCode,
                                          @RequestParam("itemCode") String itemCode);

    /**
     * 删除系统参数值
     *
     * @param ids 参数值id串
     * @return 操作结果
     */
    @DeleteMapping("/value/{ids}")
    @ApiOperation(value = "删除系统参数值", notes = "删除系统参数值，多个使用英文逗号分隔")
    @Capability(capabilityCode = "basicdata.sys-param.delete-sys-param-value")
    RestResponse<Void> deleteSysParamValue(@PathVariable("ids") String ids);

    /**
     * 为租户全量设置业务参数值(覆盖方式)
     *
     * @param sysParamValueDtoList 业务参数值实体
     * @return
     */
    @PostMapping("/value")
    @ApiOperation(value = "为租户全量设置业务参数值(覆盖方式)", notes = "为租户全量设置业务参数值(覆盖方式)")
    @Capability(capabilityCode = "basicdata.sys-param.set-sys-param-value-for-tenant")
    RestResponse<Void> setSysParamValueForTenant(@Valid @RequestBody List<SysParamValueReqDto> sysParamValueDtoList);
}
