package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.permissions.ApiPropPermissionReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * API属性权限服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：API属性权限服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IApiPropPermissionQueryApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/api-prop-permission", url = "${yundt.cube.center.data.api:}")
public interface IApiPropPermissionQueryApi {

    /**
     * 根据id查询API属性权限
     *
     * @param id API属性权限id
     * @return API属性权限数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询API属性权限", notes = "根据id查询API属性权限")
    @Capability(capabilityCode = "basicdata.api-prop-permission.query-by-id")
    RestResponse<ApiPropPermissionReqDto> queryById(@PathVariable("id") Long id);

    /**
     * API属性权限分页数据
     *
     * @param queryReqDto API属性权限查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return API属性权限分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "查询API属性权限分页数据", notes = "查询API属性权限分页数据")
    @Capability(capabilityCode = "basicdata.api-prop-permission.query-by-page")
    RestResponse<PageInfo<ApiPropPermissionReqDto>> queryByPage(@SpringQueryMap ApiPropPermissionReqDto queryReqDto,
                                                                @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
