/**
 * @(#) ISysParamApi.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.conf.BizConfQueryResp;
import com.dtyunxi.yundt.cube.center.func.api.dto.conf.BizConfigBatchQueryReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 面向应用/配置组件的api,
 *
 * @author 悠扬
 * @since 2.6.21.0
 */
@Api(tags = {"基础数据中心：配置项管理：配置读取服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IBizConfDataQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v2/conf", url = "${yundt.cube.center.data.api:}")
public interface IBizConfDataQueryApi {

    /**
     * 查询可用的配置项及可能的
     *
     * @param configQueryReq 扩展点查询条件
     * @return 配置项信息, 如果没有可用
     */
    @RequestMapping(method = RequestMethod.GET)
    @ApiOperation(value = "查询可能使用的配置项")
    @Capability(capabilityCode = "basicdata.biz-conf-data.query-conf-by-codes")
    RestResponse<List<BizConfQueryResp>> queryConfByCodes(@SpringQueryMap BizConfigBatchQueryReq configQueryReq);

}
