package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceTreeReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceConfigValueRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceTreeDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * 业务空间服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理业务空间服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IBizSpaceQueryApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/biz-space", url = "${yundt.cube.center.data.api:}")
public interface IBizSpaceQueryApi {

    /**
     * 根据code查询业务空间
     *
     * @param bizSpaceReqDto 业务空间基本查询dto
     * @return 业务空间数据
     */
    @GetMapping("/code")
    @ApiOperation(value = "根据code查询业务空间", notes = "根据code查询业务空间")
    @Capability(capabilityCode = "basicdata.biz-space.query-by-code")
    RestResponse<BizSpaceRespDto> queryByCode(@Valid @SpringQueryMap BizSpaceReqDto bizSpaceReqDto);

    /**
     * 业务空间分页数据
     *
     * @param bizSpaceQueryReqDto 业务空间查询条件
     * @param pageNum             当前页
     * @param pageSize            页大小
     * @return 业务空间分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "业务空间分页数据", notes = "业务空间分页数据")
    @Capability(capabilityCode = "basicdata.biz-space.query-by-page")
    RestResponse<PageInfo<BizSpaceRespDto>> queryByPage(@Valid @SpringQueryMap BizSpaceQueryReqDto bizSpaceQueryReqDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 查询业务空间关联的信息，构建树
     *
     * @param bizSpaceTreeReqDto 业务空间基本查询dto
     * @return 业务空间数据
     */
    @GetMapping("/tree")
    @ApiOperation(value = "查询业务空间关联的信息，构建树", notes = "查询业务空间关联的信息，构建树")
    @Capability(capabilityCode = "basicdata.biz-space.get-biz-space-tree")
    RestResponse<BizSpaceTreeDto> getBizSpaceTree(@Valid @SpringQueryMap BizSpaceTreeReqDto bizSpaceTreeReqDto);

    /**
     * 查询业务空间关联的信息,只返回关联信息的code ，需要和查询全部场景能力配置项的接口使用（v1/ability/overview）
     *
     * @param bizSpaceTreeReqDto
     * @return
     */
    @GetMapping("/relation")
    @ApiOperation(value = "查询业务空间关联的信息,只返回关联信息的code", notes = "查询业务空间关联的信息,只返回关联信息的code,配置项类型、业务参数选项值等关键信息；层级结构为\"data\": {\n" +
            "\t 业务空间基本信息,\n" +
            "    \"children\": [\n" +
            "      {\n" +
            "\t\t\"code\": \"配置项code\",\n" +
            "        \"parentCode\": \"能力code\"\n" +
            "        \"children\": [\n" +
            "          {\n" +
            "\t\t\t配置项选项信息\n" +
            "          }\n" +
            "        ],\n" +
            "       \n" +
            "      }\n" +
            "    ]\n" +
            "  }")
    @Capability(capabilityCode = "basicdata.biz-space.get-biz-space-relation")
    RestResponse<BizSpaceTreeDto> getBizSpaceRelation(@Valid @SpringQueryMap BizSpaceTreeReqDto bizSpaceTreeReqDto);

    /**
     * 查询业务空间关联的配置项设置的值列表
     *
     * @param bizSpaceReqDto 业务空间基本查询dto
     * @return 业务空间关联的配置项设置的值列表
     */
    @GetMapping("/value")
    @ApiOperation(value = "查询业务空间关联的配置项设置的值列表", notes = "查询业务空间关联的配置项设置的值列表")
    @Capability(capabilityCode = "basicdata.biz-space.query-config-value")
    RestResponse<List<BizSpaceConfigValueRespDto>> queryConfigValue(@Valid @SpringQueryMap BizSpaceReqDto bizSpaceReqDto);
}
