package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.EoQueryReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.EntityDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * EO服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：功能包EO服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-query-IEoQueryApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/eo", url = "${yundt.cube.center.data.api:}")
public interface IEoQueryApi {


    /**
     * 根据EoQueryReqDto设置的条件，查询EO列表及其EO关联的属性
     *
     * @param eoReqDto EO查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return EO列表及其EO关联的属性
     */
    @GetMapping
    @ApiOperation(value = "分页查询EO及其关联的属性", notes = "根据EoReqDto设置的条件，查询EO列表及其EO关联的属性")
    @Capability(capabilityCode = "basicdata.eo.query-by-page")
    RestResponse<PageInfo<EntityDto>> queryByPage(@SpringQueryMap @Valid EoQueryReqDto eoReqDto,
                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "1000") Integer pageSize);

    @GetMapping("/app-code-version")
    @ApiOperation(value = "根据应用编码和版本查询Eo 列表", notes = "根据应用编码和版本号查询 Eo 列表")
    RestResponse<List<EntityDto>> queryByAppCodeAndVersion(@RequestParam(name = "appCode") String appCode,
                                                           @RequestParam(name = "appVersion") String appVersion);
}
