package com.dtyunxi.yundt.cube.center.func.api.query;


import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingValueTreeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingViewRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ViewDescRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ViewSettingTreeDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 配置视图服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：配置视图服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-ISettingViewQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/setting-view", url = "${yundt.cube.center.data.api:}")
public interface ISettingViewQueryApi {

    /**
     * 根据id查询配置视图
     *
     * @param id 配置视图id
     * @return 配置视图数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询配置视图", notes = "根据id查询配置视图")
    @Capability(capabilityCode = "basicdata.setting-view.query-by-id")
    RestResponse<SettingViewRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 配置视图分页数据
     *
     * @param settingViewQueryReqDto 配置视图查询条件
     * @param pageNum                当前页
     * @param pageSize               页大小
     * @return 配置视图分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "配置视图分页数据", notes = "分页查询条件查询配置视图数据")
    @Capability(capabilityCode = "basicdata.setting-view.query-by-page")
    RestResponse<PageInfo<SettingViewRespDto>> queryByPage(@SpringQueryMap SettingViewQueryReqDto settingViewQueryReqDto,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询配置视图可关联的能力、配置项，并返回该视图已关联的节点，构建树
     *
     * @param viewSettingQueryReqDto
     * @return
     */
    @GetMapping("/setting")
    @ApiOperation(value = "查询配置视图可关联的能力、配置项，并返回该视图已关联的节点；返回领域节点；构建树",
            notes = "查询配置视图可关联的能力、配置项，并返回该视图已关联的节点；返回领域节点；构建树")
    @Capability(capabilityCode = "basicdata.setting-view.query-view-setting-tree")
    RestResponse<PageInfo<ViewSettingTreeDto>> queryViewSettingTree(@SpringQueryMap ViewSettingQueryReqDto viewSettingQueryReqDto);

    /**
     * 查询配置视图结果树中指定节点的子节点，构建子节点树
     *
     * @param viewNodeQueryReqDto
     * @return
     */
    @GetMapping("/node")
    @ApiOperation(value = "查询配置视图结果树中指定节点的子节点，构建子节点树",
            notes = "查询配置视图结果树中指定节点的子节点，构建子节点树")
    @Capability(capabilityCode = "basicdata.setting-view.query-view-node-children")
    RestResponse<PageInfo<ViewSettingTreeDto>> queryViewNodeChildren(@SpringQueryMap ViewNodeQueryReqDto viewNodeQueryReqDto);


    /**
     * 查询可设定的配置值：全局、租户、业务空间、业务身份
     *
     * @param settingValueQueryReqDto
     * @return
     */
    @GetMapping("/setting-value")
    @ApiOperation(value = "查询可设定的配置值：全局、租户、业务空间、业务身份；不返回领域节点",
            notes = "查询可设定的配置值：全局、租户、业务空间、业务身份；不返回领域节点")
    @Capability(capabilityCode = "basicdata.setting-view.query-setting-value-tree")
    RestResponse<PageInfo<SettingValueTreeRespDto>> querySettingValueTree(@SpringQueryMap SettingValueQueryReqDto settingValueQueryReqDto);

    /**
     * 查询指定配置项候选项的依赖的配置项
     *
     * @param optionDepdSettingDto
     * @return
     */
    @GetMapping("/dependency/setting-value")
    @ApiOperation(value = "查询指定配置项候选项的依赖的配置项", notes = "查询指定配置项候选项的依赖的配置项")
    @Capability(capabilityCode = "basicdata.setting-view.query-depd-setting-value-tree")
    RestResponse<PageInfo<SettingValueTreeRespDto>> queryDepdSettingValueTree(@SpringQueryMap OptionDepdSettingDto optionDepdSettingDto);

    /**
     * 根据视图id获取当前视图下有备注信息的所有能力、配置项
     *
     * @param viewDescReqDto
     * @return
     */
    @GetMapping("/item-with-desc")
    @ApiOperation(value = "根据视图id获取当前视图下有备注信息的所有能力、配置项", notes = "根据视图id获取当前视图下有备注信息的所有能力、配置项")
    @Capability(capabilityCode = "basicdata.setting-view.query-setting-value-tree")
    RestResponse<ViewDescRespDto> getViewAllItemDescByViewId(@SpringQueryMap ViewDescReqDto viewDescReqDto);
}
