/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.confimpl.ext;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.OrgTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.exception.BundleExceptionCode;
import com.dtyunxi.yundt.cube.center.user.conf.ext.IOrgTypeValidationExt;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@CubeExtImpl(name="\u7ec4\u7ec7\u7c7b\u578b\u6821\u9a8c\u6269\u5c55\u70b9", descr="\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u90e8\u95e8\u4e0d\u80fd\u6709\u516c\u53f8\u7c7b\u578b\u7684\u5b50\u7ec4\u7ec7")
@Service
public class OrgTypeValidationExtImpl
implements IOrgTypeValidationExt {
    private static final Logger logger = LoggerFactory.getLogger(OrgTypeValidationExtImpl.class);
    @Autowired
    private OrganizationDas organizationDas;

    public void execute(OrganizationDto organizationDto) {
        Integer parentType;
        OrganizationEo parent;
        Integer type = this.convertTypeFromString2Integer(organizationDto.getType());
        if (organizationDto.getParentId() != null && organizationDto.getParentId().compareTo(0L) != 0 && (parent = (OrganizationEo)this.organizationDas.selectByPrimaryKey(organizationDto.getParentId())) != null && OrgTypeEnum.DEPARTMENT.isEqual(parentType = this.convertTypeFromString2Integer(organizationDto.getType())) && OrgTypeEnum.COMPANY.isEqual(parentType)) {
            throw new BizException(BundleExceptionCode.COMPANY_NOT_ALLOWED_BELONG_TO_DEPARTMENT.getMsg());
        }
        if (OrgTypeEnum.DEPARTMENT.isEqual(type) && CollectionUtils.isNotEmpty((Collection)organizationDto.getChildren()) && organizationDto.getChildren().stream().anyMatch(children -> OrgTypeEnum.COMPANY.isEqual(this.convertTypeFromString2Integer(children.getType())))) {
            throw new BizException(BundleExceptionCode.COMPANY_NOT_ALLOWED_BELONG_TO_DEPARTMENT.getMsg());
        }
    }

    private Integer convertTypeFromString2Integer(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (Exception e) {
            logger.info("\u68c0\u6d4b\u65b0\u589e\u7ec4\u7ec7\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }
}

