/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationInfoService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORGANIZATION_INFO_TAG")
public class OrganizationInfoProcessor
implements IMessageProcessor {
    private static Logger logger = LoggerFactory.getLogger(OrganizationInfoProcessor.class);
    @Resource
    private IOrganizationInfoService organizationInfoService;

    public MessageResponse process(Object message) {
        logger.debug("\u6536\u5230\u7ec4\u7ec7\u4fe1\u606f\u65b0\u589e\u6216\u4fee\u6539\u4e8b\u4ef6\uff0c\u540c\u6b65\u65b0\u589e\u6216\u4fee\u6539\u7ec4\u7ec7\u4fe1\u606f..");
        if (message == null) {
            return MessageResponse.SUCCESS;
        }
        String str = (String)message;
        logger.debug("\u6d88\u606f\u5185\u5bb9\uff1a" + str);
        CustomerOrgInfoDto dto = (CustomerOrgInfoDto)JSON.parseObject((String)str, CustomerOrgInfoDto.class);
        if (dto == null || dto.getId() == null) {
            logger.warn("\u7ec4\u7ec7\u4fe1\u606f\u7f3a\u5931\uff0c\u4e0d\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        CustomerOrgInfoDto orgInfo = this.organizationInfoService.queryCustomerOrgInfoById(dto.getId());
        if (Objects.isNull(orgInfo)) {
            this.organizationInfoService.addCustomerOrgInfo(dto);
        } else {
            this.organizationInfoService.updateCustomerOrgInfo(dto);
        }
        return MessageResponse.SUCCESS;
    }
}

