/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.ImportCustomerResult;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.condition.Criteria;
import com.dtyunxi.yundt.cube.center.user.biz.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.CustomerOrganizationRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.CustomerEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.CustomerOrganizationRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@Service
public class CustomerServiceImpl
implements ICustomerService {
    @Autowired
    private CustomerDas customerDas;
    @Autowired
    private OrganizationDas organizationDas;
    @Autowired
    private CustomerOrganizationRelationDas customerOrganizationRelationDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomer(Long orgId, CustomerDto customerDto) {
        this.validateOrg(orgId);
        if (this.validateCustomerExists(null, customerDto)) {
            throw new BizException(UserExceptionCode.CUSTOMER_EXIT_FAIL.getCode(), UserExceptionCode.CUSTOMER_EXIT_FAIL.getMsg());
        }
        CustomerEo customerEo = this.saveCustomer(orgId, customerDto);
        return customerEo.getId();
    }

    private void validateOrg(Long orgId) {
        if (orgId != null) {
            OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(orgId);
            AssertUtil.isTrue((organizationEo != null ? 1 : 0) != 0, (String)UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), (String)UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg(), (Object[])new Object[0]);
        }
    }

    private CustomerEo saveCustomer(Long orgId, CustomerDto customerDto) {
        CustomerEo customerEo = new CustomerEo();
        DtoHelper.dto2Eo((BaseVo)customerDto, (BaseEo)customerEo);
        this.customerDas.insert((BaseEo)customerEo);
        if (orgId != null) {
            CustomerOrganizationRelationEo customerOrganizationRelationEo = new CustomerOrganizationRelationEo();
            customerOrganizationRelationEo.setCustomerId(customerEo.getId());
            customerOrganizationRelationEo.setOrganizationId(orgId);
            this.customerOrganizationRelationDas.insert((BaseEo)customerOrganizationRelationEo);
        }
        return customerEo;
    }

    @Override
    public PageInfo<CustomerDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        Criteria criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        CustomerEo customerEo = new CustomerEo();
        customerEo.setSqlFilters(criteria.getFilters());
        customerEo.setOrderBy(criteria.getOrderBy());
        customerEo.setOrderByDesc(criteria.getOrderByDesc());
        PageInfo pageInfo = this.customerDas.selectPage((BaseEo)customerEo, pageNum, pageSize);
        PageInfo dtoPage = QueryUtil.eoPage2DtoPage((PageInfo)pageInfo, CustomerDto.class);
        return dtoPage;
    }

    @Override
    public void deleteCustomer(Long id) {
        this.customerDas.logicDeleteById(id);
    }

    @Override
    public CustomerDto queryById(Long id) {
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(id);
        if (customerEo == null) {
            return null;
        }
        CustomerDto customerDto = new CustomerDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerDto);
        return customerDto;
    }

    @Override
    public void updateCustomer(Long id, CustomerDto customerDto) {
        if (this.validateCustomerExists(id, customerDto)) {
            throw new BizException(UserExceptionCode.CUSTOMER_EXIT_FAIL.getCode(), UserExceptionCode.CUSTOMER_EXIT_FAIL.getMsg());
        }
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(id);
        AssertUtil.isTrue((customerEo != null ? 1 : 0) != 0, (String)UserExceptionCode.CUSTOMER_NON_EXIT_FAIL.getCode(), (String)UserExceptionCode.CUSTOMER_NON_EXIT_FAIL.getMsg(), (Object[])new Object[0]);
        CustomerEo update = new CustomerEo();
        DtoHelper.dto2Eo((BaseVo)customerDto, (BaseEo)update);
        update.setId(id);
        this.customerDas.updateSelective((BaseEo)update);
    }

    private boolean validateCustomerExists(Long id, CustomerDto customerDto) {
        CustomerEo customerEo;
        boolean isExists = false;
        if (customerDto.getTenantId() != null && customerDto.getBusinessCode() != null && (customerEo = this.customerDas.getCustomerByTenantIdAndBusinessCode(customerDto.getTenantId(), customerDto.getBusinessCode())) != null && !customerEo.getId().equals(id)) {
            isExists = true;
        }
        return isExists;
    }

    @Override
    public ImportCustomerResult importCustomer(Long orgId, List<CustomerDto> customerDtoList) {
        this.validateOrg(orgId);
        ImportCustomerResult result = this.addImportCustomer(orgId, customerDtoList);
        return result;
    }

    private ImportCustomerResult addImportCustomer(Long orgId, List<CustomerDto> customerDtoList) {
        HashMap sucessMsg = Maps.newHashMap();
        HashMap errorMsg = Maps.newHashMap();
        for (CustomerDto customerDto : customerDtoList) {
            if (this.validateCustomerExists(null, customerDto)) {
                errorMsg.put(customerDto.toString(), UserExceptionCode.CUSTOMER_EXIT_FAIL.getMsg());
                continue;
            }
            CustomerEo customerEo = this.saveCustomer(orgId, customerDto);
            sucessMsg.put(customerDto.toString(), customerEo.getId());
        }
        ImportCustomerResult result = new ImportCustomerResult();
        result.setSuccessMsg((Map)sucessMsg);
        result.setErrorMsg((Map)errorMsg);
        return result;
    }
}

