/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.dao.das;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.user.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserOrganizationMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserOrganizationDas
extends AbstractBaseDas<UserOrganizationEo, Long> {
    @Resource
    private UserOrganizationMapper userOrgMapper;

    public List<UserOrganizationEo> selectListByUserId(Long userId) {
        UserOrganizationEo queryEo = new UserOrganizationEo();
        queryEo.setUserId(userId);
        return this.select((BaseEo)queryEo, 1, 5000);
    }

    public List<UserOrganizationEo> selectListByOrgId(Long orgId) {
        UserOrganizationEo queryEo = new UserOrganizationEo();
        queryEo.setOrganizationId(orgId);
        return this.select((BaseEo)queryEo, 1, 5000);
    }

    public List<UserOrganizationEo> selectListByUserIdAndOrgIdList(Long userId, List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return Lists.newArrayList();
        }
        UserOrganizationEo queryEo = new UserOrganizationEo();
        queryEo.setUserId(userId);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"organization_id", (Object)StringUtils.join(orgIdList, (String)",")));
        queryEo.setSqlFilters(sqlFilterList);
        return this.select((BaseEo)queryEo, 1, 5000);
    }

    public List<UserEo> selectUsers(UserEo queryEo) {
        return this.userOrgMapper.selectUsers(queryEo);
    }

    public IPage<UserEo> selectUserPage(Page<UserEo> page, UserEo queryEo) {
        return this.userOrgMapper.selectUserPage(page, queryEo);
    }
}

