package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityRemoveDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 能力信息服务接口
 *
 * @author 代码生成器
 * @see com.dtyunxi.yundt.cube.center.func.api.ICapabilityApi
 */
@Api(tags = {"基础数据中心：功能包能力地图：能力信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IAbilityApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/ability", url = "${yundt.cube.center.data.api:}")
@Deprecated
public interface IAbilityApi {

    /**
     * 新增能力信息
     *
     * @param addReqDto 能力信息请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增能力信息", notes = "新增能力信息")
    @Capability(capabilityCode = "basicdata.ability.add-ability")
    RestResponse<String> addAbility(@RequestBody @Valid AbilityCreateReqDto addReqDto);

    /**
     * 修改能力信息
     *
     * @param modifyReqDto 能力信息请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改能力信息", notes = "修改能力信息")
    @Capability(capabilityCode = "basicdata.ability.modify-ability")
    RestResponse<Void> modifyAbility(@RequestBody AbilityModifyReqDto modifyReqDto);

    /**
     * 删除能力信息
     *
     * @param abilityRemoveDto 能力信息删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("")
    @ApiOperation(value = "删除能力信息", notes = "删除能力信息")
    @Capability(capabilityCode = "basicdata.ability.remove-ability")
    RestResponse<Void> removeAbility(@SpringQueryMap AbilityRemoveDto abilityRemoveDto);
}
