package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupRemoveReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupSortDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 能力分类信息，包含领域信息、场景信息服务接口
 *
 * @author 代码生成器
 * @see com.dtyunxi.yundt.cube.center.func.api.ICapabilityApi
 */
@Api(tags = {"基础数据中心：功能包能力地图：能力分类信息，包含领域信息、场景信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IAbilityGroupApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/ability-group", url = "${yundt.cube.center.data.api:}")
@Deprecated
public interface IAbilityGroupApi {

    /**
     * 新增能力分类信息，包含领域信息、场景信息
     *
     * @param abilityGroupCreateReqDto 能力分类信息，包含领域信息、场景信息请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增能力分类信息，包含领域信息、场景信息", notes = "新增能力分类信息，包含领域信息、场景信息")
    @Capability(capabilityCode = "basicdata.ability-group.add-ability-group")
    RestResponse<String> addAbilityGroup(@Valid @RequestBody AbilityGroupCreateReqDto abilityGroupCreateReqDto);

    /**
     * 修改能力分类信息，包含领域信息、场景信息
     *
     * @param abilityGroupModifyReqDto 能力分类信息，包含领域信息、场景信息请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改能力分类信息，包含领域信息、场景信息", notes = "修改能力分类信息，包含领域信息、场景信息")
    @Capability(capabilityCode = "basicdata.ability-group.modify-ability-group")
    RestResponse<Void> modifyAbilityGroup(@Valid @RequestBody AbilityGroupModifyReqDto abilityGroupModifyReqDto);

    /**
     * 删除能力分类信息，包含领域信息、场景信息
     *
     * @param abilityGroupRemoveReqDto 能力分类信息，包含领域信息、场景信息删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/code")
    @ApiOperation(value = "删除能力分类信息，包含领域信息、场景信息", notes = "删除能力分类信息，包含领域信息、场景信息")
    @Capability(capabilityCode = "basicdata.ability-group.remove-ability-group")
    RestResponse<Void> removeAbilityGroup(@Valid @SpringQueryMap AbilityGroupRemoveReqDto abilityGroupRemoveReqDto);

    /**
     * 上移、下移、置顶、置底 能力分类，同级移动
     *
     * @param abilityGroupSortDto
     * @return
     */
    @PutMapping("/sort")
    @ApiOperation(value = "上移、下移、置顶、置底 能力分类， 同一父节点下的同级移动", notes = "上移、下移、置顶、置底 能力分类，同一父节点下的同级移动")
    @Capability(capabilityCode = "basicdata.ability-group.sort-ability-group")
    RestResponse<Void> sortAbilityGroup(@Valid @RequestBody AbilityGroupSortDto abilityGroupSortDto);

}
