package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstanceApiReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 应用实例-API关系服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：功能包能力地图：应用实例-API关系服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-query-IAppInstanceApiApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/app-instance-api", url = "${yundt.cube.center.data.api:}")
public interface IAppInstanceApiApi {

    /**
     * 授权/取消授权应用API访问权限
     *
     * @param addReqDto 应用实例-API关系表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "授权/取消授权应用API访问权限", notes = "授权/取消授权应用API访问权限")
    @Capability(capabilityCode = "basicdata.app-instance-api.add-app-instance-api")
    RestResponse<Void> addAppInstanceApi(@RequestBody AppInstanceApiReqDto addReqDto);

}
