package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DomainDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author shuangqing
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：领域服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IDataMetaApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/meta", url = "${yundt.cube.center.data.api:}")
public interface IDataMetaApi {


    @PostMapping("/domain")
    @ApiOperation(value = "新增领域", notes = "新增领域")
    RestResponse<Void> addDomain(@RequestBody DomainDto domainDto);

    @PutMapping("/domain")
    @ApiOperation(value = "编辑领域", notes = "编辑领域")
    RestResponse<Void> modifyDomain(@RequestBody DomainDto domainDto);

    @DeleteMapping("/domain/{domainId}")
    @ApiOperation(value = "删除领域", notes = "删除领域")
    RestResponse<Void> delDomain(@PathVariable("domainId") Long domainId);

}
