package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocRemoveReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocUpdateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ShelfStatusReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"基础数据中心：功能包能力地图：领域场景文档服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IDocApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IDocApi {

    /**
     * 新增领域、场景文档
     *
     * @param docCreateReqDto
     * @return
     */
    @PostMapping("/v1/doc/add")
    @ApiOperation(value = "新增领域、场景文档", notes = "新增领域、场景文档")
    @Capability(capabilityCode = "basicdata.doc.add")
    RestResponse<Void> add(@RequestBody DocCreateReqDto docCreateReqDto);

    /**
     * 编辑领域、场景文档
     *
     * @param docUpdateReqDto
     * @return
     */
    @PutMapping("/v1/doc/modify")
    @ApiOperation(value = "编辑领域、场景文档", notes = "编辑领域、场景文档")
    @Capability(capabilityCode = "basicdata.doc.modify")
    RestResponse<Void> modify(@RequestBody DocUpdateReqDto docUpdateReqDto);

    /**
     * 上下架文档
     *
     * @param statusReqDto
     * @return
     */
    @PutMapping("/v1/doc/shelf")
    @ApiOperation(value = "上下架文档", notes = "上下架文档")
    @Capability(capabilityCode = "basicdata.doc.shelf")
    RestResponse<Void> shelf(@RequestBody ShelfStatusReqDto statusReqDto);

    /**
     * 删除领域、场景文档
     *
     * @param docRemoveReqDto
     * @return
     */
    @DeleteMapping("/v1/doc")
    @ApiOperation(value = "删除领域、场景文档", notes = "删除领域、场景文档")
    @Capability(capabilityCode = "basicdata.doc.remove")
    RestResponse<Void> remove(@SpringQueryMap DocRemoveReqDto docRemoveReqDto);
}
