/**
 * @(#) BundleType.java 1.0 2020-03-09
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * 功能包类型
 *
 * @author 飞扬
 * @since 1.0.0
 */
public enum BundleType {

    // 前端使用的key，BundleEo对应的字段名称，前端key对应的展示名称
    FRONTEND("frontend", "frontendFlag", "前端应用"),
    BACKEND("backend", "backendFlag", "后端应用"),
    CENTER("center", "centerFlag", "能力中心");

    private final String frontendName;
    private final String dbFieldName;
    private final String typeDesc;

    private static final Map<String, BundleType> frontendNameMap = new HashMap<>(8);

    static {
        for (BundleType bundleType : values()) {
            frontendNameMap.put(bundleType.getFrontendName(), bundleType);
        }
    }

    BundleType(String frontendName, String dbFieldName, String typeDesc) {
        this.frontendName = frontendName;
        this.dbFieldName = dbFieldName;
        this.typeDesc = typeDesc;
    }

    public static BundleType getByFrontendName(String frontendName) {
        return frontendNameMap.get(frontendName);
    }

    public String getFrontendName() {
        return frontendName;
    }

    public String getDbFieldName() {
        return dbFieldName;
    }

    public String getTypeDesc() {
        return typeDesc;
    }
}