package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

public enum GradeType {

    /**
     * 全局
     */
    GLOBAL(0),

    /**
     * 租户
     */
    TENANT(1),
    /**
     * 应用
     */
    APPINSTANCE(2);

    private static final Map<Integer, GradeType> codeMapping = new HashMap<>();

    static {
        for (GradeType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    GradeType(int code) {
        this.code = code;
    }

    public static GradeType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}