package com.dtyunxi.yundt.cube.center.func.api.constants;

/**
 * * 选择型配置项，选项的数据来源
 * * 1 默认值，静态选项，通过注解Option定义功能包配置项选项
 * * 2 动态选项，从基础数据中心字典表bd_dict获取配置项选项
 * * 3 动态选项，由使用功能包的应用提供配置项选项
 */
public enum OptionSourceType {

    STATIC(1),
    DYNAMIC_FROM_DICT(2),
    DYNAMIC_FROM_APP(3);
    private final int value;

    OptionSourceType(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public boolean equals(Integer value) {
        return value != null && value.equals(this.value);
    }
}
