package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

public enum ParamSelectType {

    /**
     * 输入
     */
    TEXT_FIELD(0),

    /**
     * 单选
     */
    SINGLE_SELECT(1),
    /**
     * 多选
     */
    MULTI_SELECT(2);

    private static final Map<Integer, ParamSelectType> codeMapping = new HashMap<>();

    static {
        for (ParamSelectType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    ParamSelectType(int code) {
        this.code = code;
    }

    public static ParamSelectType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}