/**
 * @(#) SysParamConstants.java 1.0 2019-10-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * 配置项值编辑类型
 *
 * @author shuangqing
 * @since 1.0.0
 */
public enum SettingEditType {


    /**
     * 输入
     */
    INPUT(1),

    /**
     * 选择
     */
    CHOICE(2);

    private static final Map<Integer, SettingEditType> codeMapping = new HashMap<>();

    static {
        for (SettingEditType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    SettingEditType(int code) {
        this.code = code;
    }

    public static SettingEditType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}


