/**
 * @(#) SysParamConstants.java 1.0 2019-10-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * 配置项执行机制
 *
 * @author shuangqing
 * @since 1.0.0
 */
public enum SettingExtptExecMechanism {


    /**
     * 顺序执行
     */
    SEQUENTIAL(0),

    /**
     * 使用线程池执行
     */
    PARALLEL(1);

    private static final Map<Integer, SettingExtptExecMechanism> codeMapping = new HashMap<>();

    static {
        for (SettingExtptExecMechanism type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    SettingExtptExecMechanism(int code) {
        this.code = code;
    }

    public static SettingExtptExecMechanism fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}


