/**
 * @(#) SysParamConstants.java 1.0 2019-10-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * 配置项值类型
 *
 * @author shuangqing
 * @since 1.0.0
 */
public enum SettingValueType {


    /**
     * 整型
     */
    INTEGER(11),

    /**
     * 数值
     */
    NUMBERIC(12),

    /**
     * 日期
     */
    DATE(13),

    /**
     * 布尔
     */
    BOOLEAN(14),

    /**
     * 字符串
     */
    STRING(15),
    /**
     * 时间段
     */
    TIME_SLOT(16),

    /**
     * 表格类型
     */
    TABULAR(17),

    /**
     * 枚举
     */
    ENUM(20),

    /**
     * SPI扩展点
     */
    SPIEXTPT(31),

    /**
     * 领域事件扩展点
     */
    DOMAINEVENT_EXTPT(32);

    private static final Map<Integer, SettingValueType> codeMapping = new HashMap<>();

    static {
        for (SettingValueType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    SettingValueType(int code) {
        this.code = code;
    }

    public static SettingValueType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}


