/**
 * @(#)SettingViewNodeType 1.0 2020/3/21
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author shuangqing  2020/3/21
 */
public enum SettingViewNodeType {

    /**
     * 领域
     */
    DOMAIN(0),

    /**
     * 能力
     */
    CAPABILITY(1),

    /**
     * 配置项
     */
    SETTING(2),

    /**
     * 配置项候选项
     */
    OPTION(3);

    private static final Map<Integer, SettingViewNodeType> codeMapping = new HashMap<>();

    static {
        for (SettingViewNodeType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    SettingViewNodeType(int code) {
        this.code = code;
    }

    public static SettingViewNodeType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}
