/*
 * @(#)DictDto.java 1.0 2018/8/17
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto;

import com.dtyunxi.yundt.cube.center.func.api.dto.request.BaseReqDtoV2;

import java.util.List;

/**
 * 扩展点请求基类
 *
 * @author youyang
 * @since 1.0.0
 */
public class BizExtensionDtoBase extends BaseReqDtoV2 {

    private static final long serialVersionUID = 1002006021000L;

    /**
     * 扩展点代码
     */
    private String code;

    /**
     * 扩展点名称
     */
    private String name;
    /**
     * 扩展点简介
     */
    private String desc;
    /**
     * 扩展点类型: 1: 单实现扩展点, 2:多实现扩展点
     */
    private int type;
    /**
     * 关联的应用,即配置指定实现后会在那些应用中生效
     */
    private List<String> effectApps;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public List<String> getEffectApps() {
        return effectApps;
    }

    public void setEffectApps(List<String> effectApps) {
        this.effectApps = effectApps;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }
}
