/**
 * @(#)BundleBaseDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 功能包基础DTO
 *
 * @author 代码生成器
 */
@ApiModel(value = "BundleBaseDto", description = "功能包基础DTO")
public class BundleBaseDto extends BaseReqDto {

    /**
     *  功能包编码，全局唯一，推荐使用maven的groupId+artifactId
     */
    @NotNull(message = "功能包编码不能为空")
//    @Pattern(regexp = "^\\w{1,200}$", message = "功能包编码只能为字母，下划线，数字组合且长度不能超过200个字符")
    @ApiModelProperty(value = "功能包编码，全局唯一，推荐使用maven的groupId+artifactId")
    private String code;

    /**
     *  功能包名称，全局唯一
     */
    @NotNull(message = "功能包名称不能为空")
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{1,20}$", message = "功能包名称只能为字母，下划线，数字，中文组合且长度不能超过20个字符")
    @ApiModelProperty(value = "功能包名称，全局唯一")
    private String name;

    /**
     *  功能包的类型，以逗号分隔的字符串，例如"center","frontend","backend"
     */
    @NotNull(message = "功能包类型不能为空")
    @ApiModelProperty(value = "功能包的类型，以逗号分隔的字符串，例如center,frontend,backend")
    private String type;

    /**
     *  父功能包编码
     */
    @ApiModelProperty(value = "父功能包编码")
    private String parentCode;

    /**
     *  功能包说明
     */
    @ApiModelProperty(value = "功能包说明")
    private String descr;

    /**
     *  功能包提供者
     */
    @NotNull(message = "功能包提供者不能为空")
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{1,20}$", message = "功能包提供者只能为字母，下划线，数字，中文组合且长度不能超过20个字符")
    @ApiModelProperty(value = "功能包提供者")
    private String provider;

    /**
     * 功能包版本号
     */
    private String version;

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public void setDescr(String desc) {
        this.descr = descr;
    }

    public String getDescr() {
        return this.descr;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}