/**
 * @(#)CapabilityBaseDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Size;

/**
 * @author shuangqing  2020/2/28
 */
@ApiModel(value = "CapabilityBaseDto", description = "能力基础dto")
public class CapabilityBaseDto extends BaseReqDto {

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 父编码
     */
    @ApiModelProperty(value = "父编码")
    private String parentCode;


    /**
     * 来源功能包编码
     */
    @ApiModelProperty(value = "来源功能包编码")
    private String bundleCode;

    /**
     * 简介
     */
    @Size(max = 50, message = "简介长度不能超过50个字符")
    @ApiModelProperty(value = "简介")
    private String descr;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getBundleCode() {
        return bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getDescr() {
        return descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }
}
