/**
 * @(#)SettingBaseDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * 配置项基础dto
 *
 * @author shuangqing  2020/2/28
 */
@ApiModel(value = "SettingBaseDto", description = "配置项基础dto")
public class SettingBaseDto extends BaseReqDto {

    /**
     * 配置项编码
     */
    @NotNull(message = "配置项编码不能为空")
    @Pattern(regexp = "[A-Za-z0-9_.]{1,200}$", message = "配置项编码只支持字母，数字，下划线，点号组合字符")
    @Size(min = 1, max = 200, message = "配置项编码长度不能超过200个字符")
    @ApiModelProperty(value = "配置项编码")
    private String code;

    /**
     * 配置项 名称
     */
    @Size(min = 1, max = 20, message = "配置项名称长度不能超过20个字符")
    @ApiModelProperty(value = "配置项名称")
    private String name;

    /**
     * 简介
     */
    @Size(max = 200, message = "简介长度不能超过200个字符")
    @ApiModelProperty(value = "简介")
    private String descr;

    /**
     * 级别(0:全局;1:租户;2:业务空间；3业务身份)
     */
    @ApiModelProperty(value = "级别(0:全局;1:租户;2:业务空间；3业务身份),默认0")
    private Integer displayLevel;

    /**
     * 配置视图是否可见 1 是 0 否
     */
    @ApiModelProperty(value = "配置视图是否可见 1 是 0 否 默认1")
    private Integer viewVisible;

    /**
     * 值编辑类型 (1： 输入 ；2： 选择)
     */
    @ApiModelProperty(value = "值编辑类型 (1： 输入 ；2： 选择)")
    private Integer editType;

    /**
     * 值类型 ( 11: 整型; 12: 数值; 13: 日期;14:布尔; 15:字符串;20:枚举; 31: SPI扩展; 32 领域事件扩展)
     */
    @ApiModelProperty(value = "值类型 ( 11: 整型; 12: 数值; 13: 日期;14:布尔; 15:字符串;16:时间段; 20:枚举; 31: SPI扩展; 32 领域事件扩展)")
    private Integer valueType;

    /**
     * 是否允许多选  0 不允许  1 允许
     */
    @ApiModelProperty(value = "是否允许多选  0 不允许  1 允许")
    private Integer isMultiChoice;

    /**
     * 执行机制(0:顺序执行;  1:线程池并行执行)
     */
    @ApiModelProperty(value = "执行机制(0:顺序执行;  1:线程池并行执行)")
    private Integer execMechanism;


    /**
     * 扩展点实现执行抛异常时，是否中断(0:中止并抛出异常,1:继续执行)
     */
    @ApiModelProperty(value = "扩展点实现执行抛异常时，是否中断(0:中止并抛出异常,1:继续执行)")
    private Integer abortPolicy;
    /**
     * 记录值编辑类型为 【输入】 的默认值，比如整型默认值、数值默认值、日期默认值
     */
    @ApiModelProperty(value = "记录值编辑类型为 【输入】 的默认值，比如整型默认值、数值默认值、日期默认值")
    private String defaultValue;

    /**
     * 范围值，记录整型有效区间、数值有效区间
     */
    @ApiModelProperty(value = "范围值，记录整型有效区间、数值有效区间")
    private String valueScope;

    /**
     * 来源功能包编码
     */
    @ApiModelProperty(value = "来源功能包编码")
    private String bundleCode;

    /**
     * 表示是否允许下级修改，如果为 1，则下级允许修改；0 否 1 是，默认是
     */
    @ApiModelProperty(value = "表示是否允许下级修改，如果为 1，则下级允许修改；0 否 1 是，默认是")
    private Integer isControlled;


    /**
     * 记录当前配置项来源的版本
     */
    @ApiModelProperty(value = "记录当前配置项来源的版本")
    private String version;

    /**
     * 记录当前配置项来源的jar包
     */
    @ApiModelProperty(value = "记录当前配置项来源的jar包")
    private String source;

    public Integer getViewVisible() {
        return viewVisible;
    }

    public void setViewVisible(Integer viewVisible) {
        this.viewVisible = viewVisible;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescr() {
        return descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public Integer getDisplayLevel() {
        return displayLevel;
    }

    public void setDisplayLevel(Integer displayLevel) {
        this.displayLevel = displayLevel;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public Integer getExecMechanism() {
        return execMechanism;
    }

    public void setExecMechanism(Integer execMechanism) {
        this.execMechanism = execMechanism;
    }

    public Integer getAbortPolicy() {
        return abortPolicy;
    }

    public void setAbortPolicy(Integer abortPolicy) {
        this.abortPolicy = abortPolicy;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getValueScope() {
        return valueScope;
    }

    public void setValueScope(String valueScope) {
        this.valueScope = valueScope;
    }

    public String getBundleCode() {
        return bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public Integer getIsMultiChoice() {
        return isMultiChoice;
    }

    public void setIsMultiChoice(Integer isMultiChoice) {
        this.isMultiChoice = isMultiChoice;
    }

    public Integer getIsControlled() {
        return isControlled;
    }

    public void setIsControlled(Integer isControlled) {
        this.isControlled = isControlled;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}
