package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Collection;

@ApiModel(value = "ApiBaseReqDto", description = "API基础信息查询对象")
public class ApiBaseReqDto extends RequestDto {

    @ApiModelProperty(value = "所属中心编码")
    String moduleCode;


    @ApiModelProperty(value = "请求方式")
    String method;

    @ApiModelProperty(value = "api路径列表")
    Collection<String> apiPaths;

    public String getModuleCode() {
        return moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Collection<String> getApiPaths() {
        return apiPaths;
    }

    public void setApiPaths(Collection<String> apiPaths) {
        this.apiPaths = apiPaths;
    }

    public static ApiBaseReqDto init(Collection<String> apiPaths) {
        ApiBaseReqDto apiBaseReqDto = new ApiBaseReqDto();
        apiBaseReqDto.apiPaths = apiPaths;
        return apiBaseReqDto;
    }
}