/**
 * @(#) BundleApiQueryReqDto.java 1.0 2020-04-17
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 应用授权API清单查询dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "AppInstanceApiQueryReqDto", description = "应用授权API清单查询dto")
public class AppInstanceApiQueryReqDto extends BaseDto {

    /**
     * api名称
     */
    @ApiModelProperty(value = "API名称")
    private String apiName;

    /**
     * API路径
     */
    @ApiModelProperty(value = "URL")
    private String path;

    /**
     * 请求方式
     */
    @ApiModelProperty(value = "请求方式： POST 、PUT、DELETE、GET ")
    private String method;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "所属应用编码")
    private String moduleCode;

    /**
     * 一级能力编码
     */
    @ApiModelProperty(value = "所属一级能力编码")
    private String firstCapabilityCode;

    /**
     * 应用id
     */
    @ApiModelProperty(value = "应用id")
    private Long appInstanceId;

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getModuleCode() {
        return moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }

    public String getFirstCapabilityCode() {
        return firstCapabilityCode;
    }

    public void setFirstCapabilityCode(String firstCapabilityCode) {
        this.firstCapabilityCode = firstCapabilityCode;
    }

    public Long getAppInstanceId() {
        return appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }
}
