package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 应用实例-API关系
 *
 * @author 代码生成器
 */
@ApiModel(value = "AppInstanceApiReqDto", description = "应用实例-API关系dto对象")
public class AppInstanceApiReqDto extends RequestDto {

    /**
     * 应用id
     */
    @NotNull
    @ApiModelProperty(value = "应用id")
    private Long appInstanceId;

    /**
     * 应用编码
     */
    @NotEmpty
    @ApiModelProperty(value = "所属应用编码")
    private String moduleCode;

    /**
     * 授权状态，0未授权，1授权
     */
    @NotNull
    @ApiModelProperty(value = "授权状态，0未授权，1授权")
    private Integer status;

    /**
     * API列表
     */
    @ApiModelProperty(value = "API列表")
    private List<ApiReqDto> apiList;

    public static class ApiReqDto {
        /**
         * API名称
         */
        @ApiModelProperty(value = "API名称")
        private String apiName;

        /**
         * API路径
         */
        @NotEmpty
        @ApiModelProperty(value = "API路径")
        private String path;

        /**
         * 请求方式，GET/PUT/POST/DELETE
         */
        @NotEmpty
        @ApiModelProperty(value = "请求方式，GET/PUT/POST/DELETE")
        private String method;

        public String getApiName() {
            return apiName;
        }

        public void setApiName(String apiName) {
            this.apiName = apiName;
        }

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getMethod() {
            return method;
        }

        public void setMethod(String method) {
            this.method = method;
        }
    }

    public Long getAppInstanceId() {
        return appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public String getModuleCode() {
        return moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<ApiReqDto> getApiList() {
        return apiList;
    }

    public void setApiList(List<ApiReqDto> apiList) {
        this.apiList = apiList;
    }
}