package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @Description: 扩展点范围请求Dto
 * @Author: 水镜
 * @Date: 2019/11/7 20:36
 * @Version: 0.1.0
 */
@ApiModel(value = "BizExtImplScopeReqDto", description = "扩展点范围请求Dto")
public class BizExtImplScopeReqDto extends BaseReqDto {

    private static final long serialVersionUID = 1L;

    /**
     * 业务身份
     */
    @ApiModelProperty(value = "业务身份")
    private String bizIdCode;
    /**
     * 扩展点代码
     */
    @ApiModelProperty(value = "扩展点代码")
    @NotNull(message = "扩展点代码不能为空")
    private String bextCode;
    /**
     * 扩展点实现代码
     */
    @ApiModelProperty(value = "扩展点实现代码")
    @NotNull(message = "扩展点实现代码不能为空")
    private String bextImplCode;


    public String getBizIdCode() {
        return bizIdCode;
    }

    public void setBizIdCode(String bizIdCode) {
        this.bizIdCode = bizIdCode;
    }

    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextImplCode() {
        return bextImplCode;
    }

    public void setBextImplCode(String bextImplCode) {
        this.bextImplCode = bextImplCode;
    }
}
