/**
 * @(#) BizExtImplValueReqDto.java 1.0 2019-11-23
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 扩展点执行的具体实例请求Dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "BizExtImplValueReqDto", description = "扩展点执行的具体实例请求Dto")
public class BizExtImplValueReqDto extends BaseReqDto {
    /**
     * 业务身份
     */
    @ApiModelProperty(value = "业务身份")
    private String bizIdCode;
    /**
     * 扩展点代码
     */
    @ApiModelProperty(value = "扩展点代码")
    @NotNull(message = "扩展点代码不能为空")
    private String bextCode;
    /**
     * 扩展点实现代码
     */
    @ApiModelProperty(value = "扩展点实现代码")
    private String bextImplCode;

    /**
     * 业务空间编码
     */
    @ApiModelProperty(value = "业务空间编码")
    private String bizSpaceCode;

    public String getBizIdCode() {
        return bizIdCode;
    }

    public void setBizIdCode(String bizIdCode) {
        this.bizIdCode = bizIdCode;
    }

    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextImplCode() {
        return bextImplCode;
    }

    public void setBextImplCode(String bextImplCode) {
        this.bextImplCode = bextImplCode;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }
}
