package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 业务扩展点信息修改请求dto
 *
 * @author shuangqing
 */
@ApiModel(value = "BizExtensionModifyReqDto", description = "业务扩展点信息修改请求dto")
public class BizExtensionModifyReqDto extends BaseReqDto {

    @ApiModelProperty(value = "扩展点code")
    private String bextCode;

    /**
     * 扩展点简称
     */
    @ApiModelProperty(value = "扩展点简称")
    private String bextName;

    /**
     * 扩展点简介
     */
    @ApiModelProperty(value = "扩展点简介")
    private String bextDesc;

    /**
     * 扩展点类型 1: 单实现生效  2:并行实现生效
     */
    @ApiModelProperty(value = "扩展点类型 1: 单实现生效  2:并行实现生效")
    private Integer bextType;

    /**
     * 级别(0:全局 1:租户 2:应用)
     */
    @ApiModelProperty(value = "级别(0:全局 1:租户 2:应用)")
    private Integer grade;

    /**
     * 影响的应用系统
     * 扩展点可能影响的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统扩展点可能影响的系统,多个有英文半角逗号分隔")
    private String effectApps;

    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private List<String> abilityCodes;

    @ApiModelProperty(value = "扩展点实现修改")
    private List<BizExtensionImplModifyDto> bizExtensionImplModifyDtos;

    public List<BizExtensionImplModifyDto> getBizExtensionImplModifyDtos() {
        return bizExtensionImplModifyDtos;
    }

    public void setBizExtensionImplModifyDtos(List<BizExtensionImplModifyDto> bizExtensionImplModifyDtos) {
        this.bizExtensionImplModifyDtos = bizExtensionImplModifyDtos;
    }

    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public List<String> getAbilityCodes() {
        return abilityCodes;
    }

    public void setAbilityCodes(List<String> abilityCodes) {
        this.abilityCodes = abilityCodes;
    }


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public void setBextName(String bextName) {
        this.bextName = bextName;
    }

    public String getBextName() {
        return this.bextName;
    }

    public void setBextDesc(String bextDesc) {
        this.bextDesc = bextDesc;
    }

    public String getBextDesc() {
        return this.bextDesc;
    }

    public void setBextType(Integer bextType) {
        this.bextType = bextType;
    }

    public Integer getBextType() {
        return this.bextType;
    }

    public void setEffectApps(String effectApps) {
        this.effectApps = effectApps;
    }

    public String getEffectApps() {
        return this.effectApps;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }

    public String getCurVer() {
        return this.curVer;
    }
}