package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @Description: 扩展点查询请求Dto
 * @Author: 水镜
 * @Date: 2019/11/6 17:46
 * @Version: 0.1.0
 */
@ApiModel(value = "BizExtensionQueryReqDto", description = "扩展点查询请求Dto")
public class BizExtensionQueryReqDto extends BaseVo {

    private static final long serialVersionUID = 1L;

    /**
     * 扩展点代码
     */
    @ApiModelProperty(value = "扩展点代码")
    private String bextCode;
    /**
     * 扩展点简称
     */
    @ApiModelProperty(value = "扩展点简称")
    private String bextName;
    /**
     * 扩展点简介
     */
    @ApiModelProperty(value = "扩展点简介")
    private String bextDesc;
    /**
     * 扩展点类型
     * 1: 单实现生效  2:并行实现生效
     */
    @ApiModelProperty(value = "扩展点类型：1: 单实现生效  2:并行实现生效")
    private Integer bextType;
    /**
     * 影响的应用系统
     * 扩展点可能影响的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统")
    private String effectApps;
    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;
    /**
     * 当前版本注册时间
     */
    @ApiModelProperty(value = "当前版本注册时间")
    private Date curVerReleaseTime;

    @ApiModelProperty(value = "默认返回扩展点实现信息、能力信息，要求查询不返回则  ref=ability,impl")
    private String ref;

    /**
     * 能力编码  精确
     */
    @ApiModelProperty(value = "能力编码  精确 用, 分割")
    private String abilityCodes;

    public String getAbilityCodes() {
        return abilityCodes;
    }

    public void setAbilityCodes(String abilityCodes) {
        this.abilityCodes = abilityCodes;
    }

    public String getRef() {
        return ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextName() {
        return bextName;
    }

    public void setBextName(String bextName) {
        this.bextName = bextName;
    }

    public String getBextDesc() {
        return bextDesc;
    }

    public void setBextDesc(String bextDesc) {
        this.bextDesc = bextDesc;
    }

    public Integer getBextType() {
        return bextType;
    }

    public void setBextType(Integer bextType) {
        this.bextType = bextType;
    }

    public String getEffectApps() {
        return effectApps;
    }

    public void setEffectApps(String effectApps) {
        this.effectApps = effectApps;
    }

    public String getCurVer() {
        return curVer;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }

    public Date getCurVerReleaseTime() {
        return curVerReleaseTime;
    }

    public void setCurVerReleaseTime(Date curVerReleaseTime) {
        this.curVerReleaseTime = curVerReleaseTime;
    }
}
