/**
 * @(#)BizSpaceCreateReqDto 1.0 2019/11/21
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;

/**
 * @author : 萧玄
 * @Date: 15:26 2019/12/4
 */
@ApiModel(value = "BizRuleReqDto", description = "新增业务规则参数对象")
public class BizRuleBasicReqDto extends RequestDto {

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 状态： 1启用 0禁用
     */
    @ApiModelProperty(value = "状态【1启用 0禁用】")
    private Integer status;

    /**
     * 文字描述的规则表达式
     */
    @NotEmpty(message = "表达式不能为空")
    @ApiModelProperty(value = "文字描述的规则表达式", required = true)
    private String expression;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getExpression() {
        return expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

}