/**
 * @(#)BizSpaceConfigReqDto 1.0 2019/11/23
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author shuangqing  2019/11/23
 */
@ApiModel(value = "BizSpaceConfigReqDto", description = "业务空间配置页面")
public class BizSpaceConfigReqDto extends BaseReqDto {

    @ApiModelProperty(value = "业务空间code")
    @NotNull(message = "业务空间code不能为null")
    private String bizSpaceCode;

    @ApiModelProperty(value = "能力列表(包含配置项信息)")
    private List<BizSpaceAbilityDto> abilityList;

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public List<BizSpaceAbilityDto> getAbilityList() {
        return abilityList;
    }

    public void setAbilityList(List<BizSpaceAbilityDto> abilityList) {
        this.abilityList = abilityList;
    }
}
