package com.dtyunxi.yundt.cube.center.func.api.dto.request;


import com.dtyunxi.yundt.cube.center.func.api.dto.base.CapabilityBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * 新增能力请求参数
 *
 * @author 代码生成器
 */
@ApiModel(value = "CapabilityCreateReqDto", description = "新增能力请求参数")
public class CapabilityCreateReqDto extends CapabilityBaseDto {

    /**
     * 编 码
     */
    @NotNull(message = "编码不能为空")
    @Pattern(regexp = "^([a-z][a-z0-9-.]*)?$", message = "能力编码只能由小写英文字母、数字、中横线、英文句号组成，且以小写英文字母开头")
    @Size(max = 256, message = "能力编码长度不能超过256个字符")
    @ApiModelProperty(value = "编码", required = true)
    private String code;

    /**
     * 名称
     */
    @NotNull(message = "名称不能为空 ")
    @Size(max = 20, message = "能力名称长度不能超过20个字符")
    @ApiModelProperty(value = "名称", required = true)
    private String name;

    /**
     * 来源功能包编码
     */
    @NotNull(message = "来源功能包编码不能为空")
    @ApiModelProperty(value = "来源功能包编码")
    private String bundleCode;


    /**
     * 领域编码
     */
    @NotNull(message = "来源功能包编码不能为空")
    @ApiModelProperty(value = "领域编码")
    private String domainCode;

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    @Override
    public String getBundleCode() {
        return bundleCode;
    }

    @Override
    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }
}