package com.dtyunxi.yundt.cube.center.func.api.dto.request;


import com.dtyunxi.yundt.cube.center.func.api.dto.base.CapabilityBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * 修改能力请求参数
 *
 * @author 代码生成器
 */
@ApiModel(value = "CapabilityModifyReqDto", description = "修改能力请求参数")
public class CapabilityModifyReqDto extends CapabilityBaseDto {

    /**
     * 编码
     */
    @NotNull(message = "编码不能为空")
    @Pattern(regexp = "^([a-z][a-z0-9-.]*)?$", message = "能力编码只能由小写英文字母、数字、中横线、英文句号组成，且以小写英文字母开头")
    @Size(max = 256, message = "能力编码长度不能超过256个字符")
    @ApiModelProperty(value = "编码不能修改", required = true)
    private String code;

    /**
     * 名称
     */
    @Size(max = 20, message = "能力名称长度不能超过20个字符")
    @ApiModelProperty(value = "名称", required = true)
    private String name;


    @Override
    public String getCode() {
        return code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

}