package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 领域dto
 * @Author: 水镜
 * @Date: 2020/1/10 17:30
 * @Version: 0.1.0
 */
@ApiModel(value = "DomainDto", description = "领域dto")
public class DomainDto extends BaseDto {

    /**
     *  领域id
     */
    @ApiModelProperty(value = "领域id,新增不需要填id")
    private Long id;
    /**
     *  领域编码
     */
    @ApiModelProperty(value = "领域编码")
    private String code;
    /**
     *  领域名称
     */
    @ApiModelProperty(value = "领域名称")
    private String name;

    /**
     *  获取领域实体信息的网关访问路径，例如用户中心urlPath为/api/user，由网关拼接urlPath访问用户中心获取实体信息
     */
    @ApiModelProperty(value = "获取领域实体信息的网关访问路径，例如用户中心urlPath为/api/user，"
            + "由网关拼接urlPath访问用户中心获取实体信息")
    private String urlPath;

    /**
     *  领域描述
     */
    @ApiModelProperty(value = "领域描述")
    private String remark;
    /**
     *  版本号
     */
    @ApiModelProperty(value = "版本号")
    private String version;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUrlPath() {
        return urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }
}
